package com.xebialabs.deployit.core.auth

import ai.digital.deploy.settings.GeneralSettings

import java.util
import ai.digital.deploy.sql.model.{LoginMetadata, LoginProvider, ViewAs}
import com.google.common.collect.Lists.newArrayList
import com.xebialabs.deployit.core.service.GeneralSettingsService
import com.xebialabs.deployit.security.model.XldUserProfile
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider
import com.xebialabs.deployit.security.service.UserProfileService
import com.xebialabs.deployit.security.{Permissions, RoleService, SecurityServiceLocator}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.security.authentication.AnonymousAuthenticationToken
import org.springframework.stereotype.Component

@Component
class LoginMetadataService @Autowired()(val loginProviders: util.List[LoginProvider] = newArrayList(),
                                        val roleService: RoleService, val userProfileService: UserProfileService,
                                        val generalSettingsService: GeneralSettingsService,
                                        val principalDataProvider: PrincipalDataProvider) {

  def getLoginMetadata: LoginMetadata = {
    val viewAsData = SecurityServiceLocator.getViewAsData
    var userProfile:  XldUserProfile = null
    var personalAccessTokenEnabled: Boolean = false
    val userName =
      if (Permissions.getAuthentication.isInstanceOf[AnonymousAuthenticationToken])
        null
      else
        Permissions.getAuthenticatedUserName
    val displayUsername = if(userName != null) {
      userProfile = userProfileService.findOne(userName)
      userProfile.displayUsername
    } else {
      ""
    }

    if (userProfile != null && generalSettingsService != null) {
      val generalSettings: GeneralSettings = generalSettingsService.getGeneralSettings;
      personalAccessTokenEnabled = generalSettings.patEnableForSSO || (userProfile.isInternal ||
        Option(principalDataProvider.getUserData(userProfile.username)).exists(_.isFound))
    }
    LoginMetadata(userName, loginProviders, ViewAs.fromViewAsData(viewAsData), roleService.isReadOnlyAdmin(), displayUsername, personalAccessTokenEnabled)
  }
}
