package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.DescriptorProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemDescriptorRepositoryHolder;
import com.xebialabs.deployit.typedescriptor.ConfigurationItemTypeDescriptorRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

@Controller
public class DescriptorResource implements DescriptorProxy {

	@Autowired
	private DtoConverter dtoConverter;

	@Autowired
	private ConfigurationItemTypeDescriptorRepository descriptorRepository;

	@Override
	public Response list() {
		ConfigurationItemDescriptorList descriptorList = new ConfigurationItemDescriptorList();
		List<ConfigurationItemDescriptorDto> descriptors = new ArrayList<ConfigurationItemDescriptorDto>();
		for (ConfigurationItemDescriptor descriptor : descriptorRepository.getDescriptors()) {
			ConfigurationItemDescriptorDto descriptorDto = dtoConverter.toDto(descriptor);
			descriptors.add(descriptorDto);
		}
		descriptorList.setDescriptors(descriptors);
		return ResponseFactory.ok(descriptorList).build();
	}

    @Override
    public Response find(@PathParam("type") final String type) {
        ConfigurationItemTypeDescriptorRepository descriptorRepository = ConfigurationItemDescriptorRepositoryHolder.getDescriptorRepository();
        final ConfigurationItemDescriptor descriptor = descriptorRepository.getDescriptorByType(type);
        final ConfigurationItemDescriptorDto dto = dtoConverter.toDto(descriptor);
        return ResponseFactory.ok(dto).build();
    }

}
