package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.HistoryProxy;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;

import static com.xebialabs.deployit.core.rest.api.SearchParameterFactory.createSearchParam;

@Controller
public class HistoryResource implements HistoryProxy {
	
	@Autowired
	private RepositoryService repositoryService;
	
	@Autowired
	private DtoConverter dtoConverter;

	@Override
	public Response query(String typeName, boolean archetype, long page, long resultPerPage, List<PropertyValue> values, Date at) {
		SearchParameters searchParameters = createSearchParam(typeName, archetype, page, resultPerPage, values, at);
		Collection<RepositoryObjectEntity> entities = repositoryService.listEntities(searchParameters);
		return ResponseFactory.ok(dtoConverter.toDto(entities)).build();
	}

}
