package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskRegistry;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class DeploymentsForEnvironmentReport {

    private RepositoryService repositoryService;
    private TaskRegistry taskRegistry;

    public DeploymentsForEnvironmentReport(final RepositoryService repositoryService, final TaskRegistry taskRegistry) {
        this.repositoryService = repositoryService;
        this.taskRegistry = taskRegistry;
    }

    public Report report(final String environment, final Date date) {
        final Report report = new Report();
        List<PropertyValue> values = newArrayList();
        final SearchParameters searchParams = SearchParameterFactory.createSearchParam(Deployment.class.getName(), false, 0, -1, values, environment, "");
        final List<ConfigurationItemEntity> deployments = repositoryService.listEntities(searchParams);
        for (ConfigurationItemEntity deployment : deployments) {
            if (deployment.getCreatingTaskId() != null) {
                Task task = taskRegistry.getTask(deployment.getCreatingTaskId());
                if (task.getCompletionDate().before(date.getCalendar())) {
                    final Report.ReportLine reportLine = report.addLine();
                    ConfigurationItemEntity deploymentPackage = repositoryService.read((String) deployment.getValue("source"));
                    String applicationId = deploymentPackage.getValue("application").toString();
					reportLine.addValue("application", applicationId.substring(applicationId.indexOf("/") + 1));
                    reportLine.addValue("version", deploymentPackage.getValue("version"));
                    reportLine.addValue("user", task.getOwner());
                    reportLine.addValue("date", new Date(task.getCompletionDate(), Date.FORMAT).toString());
                }
            }
        }

        return report;
    }
}
