/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.DiscoveryProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DiscoveryResource
extends AbstractSecuredResource
implements DiscoveryProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private DiscoveryService discoveryService;

    public Response discover(ConfigurationItem dto) {
        this.checkPermission(Permission.DISCOVERY);
        ConfigurationItemEntity middleware = (ConfigurationItemEntity)this.dtoConverter.fromDto((RepositoryObject)dto);
        List discovered = this.discoveryService.fetchConfigurationWithChildren(middleware);
        return ResponseFactory.ok((Object)this.dtoConverter.toDto(discovered)).build();
    }

    public Response realityCheck(String id) {
        this.checkPermission(Permission.DISCOVERY);
        ConfigurationItemEntity middlewareEntity = (ConfigurationItemEntity)this.repositoryService.read(id);
        middlewareEntity = this.discoveryService.fetchConfiguration(middlewareEntity);
        return ResponseFactory.ok((Object)this.dtoConverter.toDto((RepositoryObjectEntity)middlewareEntity)).build();
    }
}

