/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItem;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.ConfigurationItemEntity;
import com.xebialabs.deployit.repository.RepositoryObjectEntity;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.deployment.DeployedService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.validation.ValidationMessage;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeploymentResource
extends AbstractSecuredResource
implements DeploymentProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private DeployedService deployedService;
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    @Autowired
    private Validator validator;

    public Response prepareInitial(@QueryParam(value="version") String versionId, @QueryParam(value="environment") String environmentId) {
        this.checkPermission(Permission.DEPLOY_INITIAL, Lists.newArrayList((Object[])new String[]{environmentId}));
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)environmentId, (String)"environment");
        ConfigurationItemEntity version = (ConfigurationItemEntity)this.repositoryService.readFully(versionId);
        ConfigurationItemEntity environment = (ConfigurationItemEntity)this.repositoryService.readFully(environmentId);
        Checks.checkArgument((boolean)DescriptorRegistry.getDescriptor((Type)version.getType()).isAssignableTo(Version.class), (String)"%s is not a Version", (Object[])new Object[]{versionId});
        Checks.checkArgument((boolean)DescriptorRegistry.getDescriptor((Type)environment.getType()).isAssignableTo(Environment.class), (String)"%s is not an Environment", (Object[])new Object[]{environmentId});
        Deployment deployment = this.createDeployment(version, environmentId);
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response prepareUpgrade(@QueryParam(value="version") String versionId, @QueryParam(value="deployedApplication") String deployedApplicationId) {
        Checks.checkNotNull((Object)versionId, (String)"version");
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        ConfigurationItemEntity deployedApplication = (ConfigurationItemEntity)this.repositoryService.readFully(deployedApplicationId);
        Checks.checkArgument((boolean)deployedApplication.getType().equals((Object)Type.valueOf(DeployedApplication.class)), (String)"%s is not a DeployedApplication", (Object[])new Object[]{deployedApplicationId});
        String environmentId = (String)deployedApplication.getValue("environment");
        this.checkPermission(Permission.DEPLOY_UPGRADE, environmentId);
        ConfigurationItemEntity version = (ConfigurationItemEntity)this.repositoryService.readFully(versionId);
        Checks.checkArgument((boolean)DescriptorRegistry.getDescriptor((Type)version.getType()).isAssignableTo(Version.class), (String)"%s is not a Version", (Object[])new Object[]{versionId});
        ListMultimap upgradedDeployeds = this.deployedService.generateUpgradedDeployeds(version, deployedApplication);
        Deployment deployment = this.createDeployment(version, environmentId);
        deployment.setUpgrade(true);
        deployment.setDeployeds(this.dtoConverter.deployedsToDto((ListMultimap<Boolean, ConfigurationItemEntity>)upgradedDeployeds));
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response generateAllDeployeds(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        ConfigurationItemEntity version = (ConfigurationItemEntity)this.repositoryService.readFully(deployment.getVersion());
        ConfigurationItemEntity environment = (ConfigurationItemEntity)this.repositoryService.readFully(deployment.getEnvironment());
        ListMultimap initialDeployeds = this.deployedService.generateAllDeployeds(version, environment);
        deployment.addAll(this.dtoConverter.deployedsToDto((ListMultimap<Boolean, ConfigurationItemEntity>)initialDeployeds));
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response generateSelectedDeployeds(@QueryParam(value="deployables") List<String> deployableIds, Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        Checks.checkArgument((deployableIds.size() > 0 ? 1 : 0) != 0, (String)"Should select at least one deployable to generate a deployed", (Object[])new Object[0]);
        ConfigurationItemEntity environment = (ConfigurationItemEntity)this.repositoryService.readFully(deployment.getEnvironment());
        ArrayList deployableCIs = Lists.newArrayList();
        for (String id : deployableIds) {
            deployableCIs.add((ConfigurationItemEntity)this.repositoryService.readFully(id));
            Checks.checkArgument((boolean)id.startsWith(deployment.getVersion()), (String)"All sources should be from same package", (Object[])new Object[0]);
        }
        ListMultimap selectedDeployeds = this.deployedService.generateSelectedDeployeds((List)deployableCIs, environment);
        deployment.addAll(this.dtoConverter.deployedsToDto((ListMultimap<Boolean, ConfigurationItemEntity>)selectedDeployeds));
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response generateSingleDeployed(@QueryParam(value="deployable") String deployableId, @QueryParam(value="container") String containerId, @QueryParam(value="deployedtype") String deployedType, Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        this.checkPermission(Permission.DEPLOY_INITIAL, deployment.getEnvironment());
        Checks.checkNotNull((Object)deployableId, (String)"deployable");
        Checks.checkNotNull((Object)containerId, (String)"container");
        ConfigurationItemEntity deployable = (ConfigurationItemEntity)this.repositoryService.readFully(deployableId);
        ConfigurationItemEntity container = (ConfigurationItemEntity)this.repositoryService.read(containerId);
        ConfigurationItemEntity environment = (ConfigurationItemEntity)this.repositoryService.read(deployment.getEnvironment());
        ListMultimap deployeds = this.deployedService.generateSelectedDeployed(deployable, container, deployedType, environment);
        deployment.addAll(this.dtoConverter.deployedsToDto((ListMultimap<Boolean, ConfigurationItemEntity>)deployeds));
        return ResponseFactory.ok((Object)deployment).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response validate(Deployment deployment) {
        if (!this.validateDeployedsWithValidator(deployment.getDeployeds())) {
            return ResponseFactory.badRequest((Object)deployment).build();
        }
        Task task = this.createDeploymentTask(deployment);
        try {
            List taskSteps = task.getSteps();
            Preconditions.checkState((!taskSteps.isEmpty() ? 1 : 0) != 0, (Object)"The task did not deliver any steps.");
        }
        finally {
            task.destroy();
        }
        return ResponseFactory.ok((Object)deployment).build();
    }

    public Response deploy(Deployment deployment) {
        Checks.checkNotNull((Object)deployment, (String)"deployment");
        Task deploymentTask = this.createDeploymentTask(deployment);
        String taskId = this.engine.register(deploymentTask);
        Steps steps = this.dtoConverter.taskToDto(deploymentTask);
        steps.setTaskId(taskId);
        return ResponseFactory.ok((Object)steps).build();
    }

    public Response undeploy(String deployedApplicationId) {
        Checks.checkNotNull((Object)deployedApplicationId, (String)"deployedApplication");
        ConfigurationItemEntity deployedApplication = (ConfigurationItemEntity)this.repositoryService.read(deployedApplicationId);
        this.checkPermission(Permission.UNDEPLOY, (String)deployedApplication.getValue("environment"));
        Task task = this.deploymentService.prepareUndeployment(deployedApplication);
        String taskId = this.engine.register(task);
        Steps steps = this.dtoConverter.taskToDto(task);
        steps.setTaskId(taskId);
        return ResponseFactory.ok((Object)steps).build();
    }

    private Task createDeploymentTask(Deployment deployment) {
        ConfigurationItemEntity version = (ConfigurationItemEntity)this.repositoryService.readFully(deployment.getVersion());
        Task deploymentTask = null;
        if (!deployment.isUpgrade()) {
            Collection deployedEntities = this.dtoConverter.entitiesFromDto(deployment.getDeployeds());
            ConfigurationItemEntity environment = (ConfigurationItemEntity)this.repositoryService.readFully(deployment.getEnvironment());
            deploymentTask = this.deploymentService.prepareInitialDeployment(version, environment, deployedEntities);
        } else {
            Collection deployedEntities = this.dtoConverter.entitiesFromDto(deployment.getDeployeds());
            ConfigurationItemEntity existingDeployedApplication = (ConfigurationItemEntity)this.repositoryService.readFully(this.constructDeployedApplicationId(version, deployment.getEnvironment()));
            deploymentTask = this.deploymentService.prepareUpgradeDeployment(version, existingDeployedApplication, deployedEntities);
        }
        return deploymentTask;
    }

    private boolean validateDeployedsWithValidator(List<ConfigurationItem> deployeds) {
        boolean allValid = true;
        ArrayList deployedEntitiesInCtx = Lists.newArrayList(this.dtoConverter.entitiesFromDto(deployeds));
        for (int i = 0; i < deployeds.size(); ++i) {
            ConfigurationItem deployed = deployeds.get(i);
            RepositoryObjectEntity deployedEntity = (RepositoryObjectEntity)deployedEntitiesInCtx.get(i);
            Validator.Validations validations = this.validator.validate(deployedEntity, (List)deployedEntitiesInCtx);
            if (!validations.hasMessages()) continue;
            deployed.setValidations(this.dtoConverter.validationMessagesToDto((List<ValidationMessage>)validations));
            allValid = false;
        }
        return allValid;
    }

    private Deployment createDeployment(ConfigurationItemEntity version, String environmentId) {
        Deployment deployment = new Deployment();
        ConfigurationItemEntity deployedApplication = new ConfigurationItemEntity(Type.valueOf(DeployedApplication.class));
        deployedApplication.addValue("version", (Object)version.getId());
        deployedApplication.addValue("environment", (Object)environmentId);
        String id = this.constructDeployedApplicationId(version, environmentId);
        deployedApplication.setId(id);
        deployment.setDeployedApplication((ConfigurationItem)this.dtoConverter.entityToDto((RepositoryObjectEntity)deployedApplication));
        return deployment;
    }

    private String constructDeployedApplicationId(ConfigurationItemEntity version, String environmentId) {
        String applicationId = (String)version.getValue("application");
        int i = applicationId.lastIndexOf("/");
        return environmentId + applicationId.substring(i);
    }
}

