/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.TaskProxy;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.DtoConverter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.TaskStep;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.util.Calendar;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class TaskResource
extends AbstractSecuredResource
implements TaskProxy {
    @Autowired
    private DtoConverter dtoConverter;
    @Autowired
    private ExecutionEngine engine;
    @Autowired
    private TaskArchive taskArchive;
    private static final Logger logger = LoggerFactory.getLogger(TaskResource.class);

    public Response start(String taskId) {
        this.engine.execute(taskId);
        return ResponseFactory.accepted().build();
    }

    public Response cancel(String taskId) {
        this.engine.cancel(taskId);
        return ResponseFactory.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response stop(String taskId) {
        try {
            this.engine.stopExecution(taskId);
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not stop task %s", taskId), (Throwable)ise);
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)ise.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    public Response abort(String taskId) {
        try {
            this.engine.abortExecution(taskId);
        }
        catch (IllegalStateException ise) {
            logger.error(String.format("Could not abort task %s", taskId), (Throwable)ise);
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)ise.getMessage()).build();
        }
        return ResponseFactory.accepted().build();
    }

    public Response getTaskInfo(String taskId) {
        Task runningTask = this.engine.getTask(taskId);
        TaskInfo taskInfoDto = runningTask != null ? this.dtoConverter.taskToDto(taskId, runningTask) : this.dtoConverter.archivedTaskToDto(this.taskArchive.getTask(taskId));
        return ResponseFactory.ok((Object)taskInfoDto).build();
    }

    public Response toggleSkipSteps(@PathParam(value="taskid") String taskId, @PathParam(value="steps") String stepIds) {
        String[] taskStepIds;
        this.checkPermission(Permission.TASK_SKIPSTEP);
        Task task = this.engine.getTask(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        for (String stepId : taskStepIds = stepIds.split(",")) {
            int id = Integer.parseInt(stepId);
            TaskStep taskStep = task.getStep(id);
            if (taskStep.canSkip()) {
                logger.info("Skipping step :{}", (Object)taskStep.getDescription());
                taskStep.skip();
                continue;
            }
            if (!taskStep.isSkipped()) continue;
            taskStep.unskip();
        }
        return ResponseFactory.ok((Object)this.dtoConverter.taskToDto(task)).build();
    }

    public Response moveStep(@PathParam(value="taskid") String taskId, @PathParam(value="stepNr") int stepNr, @PathParam(value="position") int newPosition) {
        this.checkPermission(Permission.TASK_MOVESTEP);
        Task task = this.engine.getTask(taskId);
        Checks.checkArgument((task != null ? 1 : 0) != 0, (String)"Could not find active task %s", (Object[])new Object[]{taskId});
        task.moveStep(stepNr, newPosition);
        return ResponseFactory.ok((Object)this.dtoConverter.taskToDto(task)).build();
    }

    public Response getStepInfo(String taskId, int stepNr, Date ifModifiedSince) {
        TaskStep step;
        Task runningTask = this.engine.getTask(taskId);
        if (runningTask != null) {
            step = runningTask.getStep(stepNr);
        } else {
            DeploymentTaskInfo archivedTask = this.taskArchive.getTask(taskId);
            step = archivedTask.getStep(stepNr);
        }
        if (this.hasBeenModifiedSince((TaskStepInfo)step, ifModifiedSince)) {
            return ResponseFactory.ok((Object)this.dtoConverter.taskStepInfoToDto(stepNr, (TaskStepInfo)step)).lastModified(step.getLastModificationDate().getTime()).build();
        }
        return ResponseFactory.notModified().build();
    }

    protected boolean hasBeenModifiedSince(TaskStepInfo step, Date ifModifiedSince) {
        if (ifModifiedSince == null) {
            return true;
        }
        Calendar lastModifiedCal = step.getLastModificationDate();
        lastModifiedCal.set(14, 0);
        return ifModifiedSince.getCalendar().before(lastModifiedCal);
    }

    public Response getUnfinishedTasks() {
        return ResponseFactory.ok((Object)this.dtoConverter.tasksToDto(this.engine.getAllIncompleteTasksForCurrentUser())).build();
    }

    public Response getStepsForTask(String taskId) {
        Task runningTask = this.engine.getTask(taskId);
        Steps steps = runningTask != null ? this.dtoConverter.taskStepInfosToDto(runningTask.getSteps()) : this.dtoConverter.taskStepInfosToDto(this.taskArchive.getTask(taskId).getSteps());
        steps.setTaskId(taskId);
        return ResponseFactory.ok((Object)steps).build();
    }
}

