/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskStateData {
    private AtomicInteger noOfSuccessfulDeployments = new AtomicInteger(0);
    private AtomicInteger noOfFailedDeployments = new AtomicInteger(0);
    private AtomicInteger noOfAbortedDeployments = new AtomicInteger(0);
    private Long averageDeploymentTime = 0L;
    private AtomicInteger totalSuccessfulTasks = new AtomicInteger(0);

    public AtomicInteger getNoOfSuccessfulDeployments() {
        return this.noOfSuccessfulDeployments;
    }

    public void setNoOfSuccessfulDeployments(AtomicInteger noOfSuccessfulDeployments) {
        this.noOfSuccessfulDeployments = noOfSuccessfulDeployments;
    }

    public AtomicInteger getNoOfFailedDeployments() {
        return this.noOfFailedDeployments;
    }

    public void setNoOfFailedDeployments(AtomicInteger noOfFailedDeployments) {
        this.noOfFailedDeployments = noOfFailedDeployments;
    }

    public AtomicInteger getNoOfAbortedDeployments() {
        return this.noOfAbortedDeployments;
    }

    public void setNoOfAbortedDeployments(AtomicInteger noOfAbortedDeployments) {
        this.noOfAbortedDeployments = noOfAbortedDeployments;
    }

    public Long getAverageDeploymentTime() {
        return this.averageDeploymentTime;
    }

    public void setAverageDeploymentTime(Long averageDeploymentTime) {
        this.averageDeploymentTime = averageDeploymentTime;
    }

    public int getTotalSuccessfulTasks() {
        return this.noOfFailedDeployments.get() + this.noOfSuccessfulDeployments.get();
    }

    public int getTotalTasks() {
        return this.noOfAbortedDeployments.get() + this.noOfFailedDeployments.get() + this.noOfSuccessfulDeployments.get();
    }

    public void addTask(DeploymentTaskInfo task) {
        if (task.getState().equals((Object)Task.State.DONE)) {
            if (task.getFailureCount() > 0) {
                this.noOfFailedDeployments.incrementAndGet();
            } else {
                this.noOfSuccessfulDeployments.incrementAndGet();
            }
        } else if (task.getState().equals((Object)Task.State.CANCELLED)) {
            this.noOfAbortedDeployments.incrementAndGet();
        }
    }

    public void addTaskAndDuration(DeploymentTaskInfo task) {
        this.addTask(task);
        if (task.getState().equals((Object)Task.State.DONE)) {
            this.averageDeploymentTime = this.averageDeploymentTime + task.getDurationInMillis();
        }
    }
}

