package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.task.DeploymentTaskInfo;

import java.util.concurrent.atomic.AtomicInteger;

import static com.xebialabs.deployit.task.Task.State.CANCELLED;
import static com.xebialabs.deployit.task.Task.State.DONE;

public class TaskStateData {
	
	private AtomicInteger noOfSuccessfulDeployments = new AtomicInteger(0);
	
	private AtomicInteger noOfFailedDeployments = new AtomicInteger(0);
	
	private AtomicInteger noOfAbortedDeployments = new AtomicInteger(0);
	
	private Long averageDeploymentTime = 0L;
	
	public AtomicInteger getNoOfSuccessfulDeployments() {
		return noOfSuccessfulDeployments;
	}

	public void setNoOfSuccessfulDeployments(AtomicInteger noOfSuccessfulDeployments) {
		this.noOfSuccessfulDeployments = noOfSuccessfulDeployments;
	}

	public AtomicInteger getNoOfFailedDeployments() {
		return noOfFailedDeployments;
	}

	public void setNoOfFailedDeployments(AtomicInteger noOfFailedDeployments) {
		this.noOfFailedDeployments = noOfFailedDeployments;
	} 

	public AtomicInteger getNoOfAbortedDeployments() {
		return noOfAbortedDeployments;
	}
	
	public void setNoOfAbortedDeployments(AtomicInteger noOfAbortedDeployments) {
		this.noOfAbortedDeployments = noOfAbortedDeployments;
	}
	
	public Long getAverageDeploymentTime() {
		return averageDeploymentTime;
	}
	
	public void setAverageDeploymentTime(Long averageDeploymentTime) {
		this.averageDeploymentTime = averageDeploymentTime;
	}

	/*
	 * Derived counters
	 */

	public int getTotalSuccessfulTasks() {
		return noOfFailedDeployments.get() + noOfSuccessfulDeployments.get();
	}

	public int getTotalTasks() {
		return noOfAbortedDeployments.get() + noOfFailedDeployments.get() + noOfSuccessfulDeployments.get();
	}

	public void addTask(DeploymentTaskInfo task) {
		if (task.getState().equals(DONE)) {
			if (task.getFailureCount() > 0) {
				noOfFailedDeployments.incrementAndGet();
			} else {
				noOfSuccessfulDeployments.incrementAndGet();
			}
		} else if (task.getState().equals(CANCELLED)) {
			noOfAbortedDeployments.incrementAndGet();
		}
	}

	public void addTaskAndDuration(DeploymentTaskInfo task) {
		addTask(task);
		if (task.getState().equals(DONE)) {
			averageDeploymentTime += task.getDurationInMillis();
		}
	}
}
