package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.DiscoveryProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.ws.rs.core.Response;
import java.util.List;

/**
 */
@Controller
public class DiscoveryResource extends AbstractSecuredResource implements DiscoveryProxy {

	@Autowired
	private ConfigurationItemDtoReader dtoReader;

	@Autowired
	private ConfigurationItemDtoWriter dtoWriter;

	@Autowired
	private DiscoveryService discoveryService;

	@Override
	public Response discover(ConfigurationItemDto dto) {
		checkPermission(Permission.DISCOVERY);
        ConfigurationItem middleware = dtoReader.read(dto);
        List<ConfigurationItem> discovered = discoveryService.discoverConfigurationItem(middleware);
		return ResponseFactory.ok(dtoWriter.write(discovered)).build();
	}
}
