/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.RepositoryProxy;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoReader;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RepositoryResource
extends AbstractSecuredResource
implements RepositoryProxy {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ConfigurationItemDtoReader dtoReader;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;
    @Autowired
    private Validator validator;
    @Autowired
    private WorkDirFactory workDirFactory;

    public Response create(String id, ConfigurationItemDto dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.setId(id);
        Object ci = this.dtoReader.read(dto);
        return this.createInternal((ConfigurationItem)ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response create(String id, ArtifactAndData dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.getArtifact().setId(id);
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem ci = this.dtoReader.read(dto, workDir);
            Response response = this.createInternal(ci);
            return response;
        }
        finally {
            workDir.delete();
        }
    }

    public Response createMultiple(ConfigurationItemDtos dto) {
        this.checkPermission(Permission.EDIT_REPO, Lists.transform((List)dto.getObjects(), (Function)new Function<RepositoryObject, String>(){

            public String apply(RepositoryObject from) {
                return from.getId();
            }
        }));
        return this.createInternal(this.dtoReader.read(dto));
    }

    public Response read(String id) {
        ConfigurationItem entity = this.repositoryService.read(id);
        ConfigurationItemDto dto = this.dtoWriter.write(entity);
        return ResponseFactory.status((Response.Status)Response.Status.OK).entity((Object)dto).build();
    }

    public Response update(String id, ConfigurationItemDto dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.setId(id);
        Object ci = this.dtoReader.read(dto);
        return this.updateInternal((ConfigurationItem)ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response update(String id, ArtifactAndData dto) {
        this.checkPermission(Permission.EDIT_REPO, id);
        dto.getArtifact().setId(id);
        WorkDir workDir = this.workDirFactory.newWorkDir();
        try {
            ConfigurationItem ci = this.dtoReader.read(dto, workDir);
            Response response = this.updateInternal(ci);
            return response;
        }
        finally {
            workDir.delete();
        }
    }

    public Response delete(String id) {
        this.checkPermission(Permission.EDIT_REPO, id);
        this.repositoryService.delete(new String[]{id});
        return ResponseFactory.noContent().build();
    }

    private Response createInternal(ConfigurationItem ci) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(ci);
        if (response != null) {
            return response;
        }
        this.repositoryService.create(new ConfigurationItem[]{ci});
        return this.reloadEntityAndCreateSuccessResponse(ci);
    }

    private Response validateEntityAndCreateErrorResponseIfNeeded(ConfigurationItem ci) {
        List messages = this.validator.validate(ci, (List)Lists.newArrayList());
        if (!messages.isEmpty()) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.dtoWriter.write(ci, messages)).build();
        }
        return null;
    }

    private Response validateEntityAndCreateErrorResponseIfNeeded(Collection<ConfigurationItem> entities) {
        ConfigurationItemDtos repositoryObjects = new ConfigurationItemDtos();
        boolean allValid = true;
        ConfigurationItem[] entitiesArray = entities.toArray(new ConfigurationItem[entities.size()]);
        for (ConfigurationItem entity : entities) {
            List messages = this.validator.validate(entity, entitiesArray);
            repositoryObjects.add(this.dtoWriter.write(entity, messages));
            allValid = allValid && messages.isEmpty();
        }
        if (!allValid) {
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)repositoryObjects).build();
        }
        return null;
    }

    private Response reloadEntityAndCreateSuccessResponse(ConfigurationItem ci) {
        ConfigurationItem reloaded = this.repositoryService.read(ci.getId());
        return ResponseFactory.created((Object)this.dtoWriter.write(reloaded)).build();
    }

    private Response createInternal(Collection<ConfigurationItem> cis) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(cis);
        if (response != null) {
            return response;
        }
        ConfigurationItem[] cisArray = cis.toArray(new ConfigurationItem[cis.size()]);
        this.repositoryService.create(cisArray);
        return this.reloadEntityAndCreateSuccessResponse(cis);
    }

    private Response reloadEntityAndCreateSuccessResponse(Collection<ConfigurationItem> cis) {
        ArrayList reloadedDtos = Lists.newArrayList();
        for (ConfigurationItem entity : cis) {
            ConfigurationItem reloadedEntity = this.repositoryService.read(entity.getId());
            reloadedDtos.add(reloadedEntity);
        }
        return ResponseFactory.created((Object)this.dtoWriter.write(reloadedDtos)).build();
    }

    private Response updateInternal(ConfigurationItem ci) {
        Response response = this.validateEntityAndCreateErrorResponseIfNeeded(ci);
        if (response != null) {
            return response;
        }
        this.repositoryService.update(new ConfigurationItem[]{ci});
        return this.reloadEntityAndCreateSuccessResponse(ci);
    }
}

