package com.xebialabs.deployit.core.rest.api;

import javax.ws.rs.core.Response;
import org.springframework.stereotype.Controller;
import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.dto.PrincipalPermissions;
import com.xebialabs.deployit.core.api.dto.RepositoryObjectIds;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.security.permission.Permission;
import static com.xebialabs.deployit.security.SecurityServiceLocator.getPermissionService;

@Controller
public class SecurityResource implements SecurityProxy {

	@Override
	public Response grant(String permission, String toUser, RepositoryObjectIds onConfigurationItems) {
		getPermission(permission).getPermissionHandler().grant(toUser, onConfigurationItems.getRepositoryEntityIds());
		return ResponseFactory.noContent().build();
	}

	@Override
	public Response deny(String permission, String toUser, RepositoryObjectIds onConfigurationItems) {
		getPermission(permission).getPermissionHandler().deny(toUser, onConfigurationItems.getRepositoryEntityIds());
		return ResponseFactory.noContent().build();
	}

	@Override
	public Response revoke(String permission, String fromUser, RepositoryObjectIds onConfigurationItems) {
		getPermission(permission).getPermissionHandler().revoke(fromUser, onConfigurationItems.getRepositoryEntityIds());
		return ResponseFactory.noContent().build();
	}

	@Override
	public Response retrievePermissions(final String user) {
		return ResponseFactory.ok(new PrincipalPermissions(user, getPermissionService().getUserPermissions(user))).build();
	}

	private Permission getPermission(final String permissionName) {
		final Permission permission = Permission.find(permissionName);
		if (permission == null) {
			throw new UnknownPermissionException(permissionName);
		}
		return permission;
	}

	@SuppressWarnings("serial")
	@HttpResponseCodeResult(statusCode = 400)
	public static class UnknownPermissionException extends DeployitException {
		public UnknownPermissionException(String permission) {
			super("Permission %s does not exist.", permission);
		}
	}
}
