package com.xebialabs.deployit.core.rest.secured;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.security.AccessControlService;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;

/**
 */
public abstract class AbstractSecuredResource {

	@Autowired
	private AccessControlService accessControlService;

	protected void checkPermission(Permission permission) {
		checkPermission(permission, Lists.<String>newArrayList());
	}

	protected void checkPermission(Permission permission, String id) {
		checkPermission(permission, newArrayList(id));
	}

	protected void checkPermission(Permission permission, List<String> onConfigurationItems) {
		if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
			throw PermissionDeniedException.forPermission(permission, onConfigurationItems);
		}
	}

	protected void checkWriteAccessTo(String id) {
		if (!accessControlService.hasPrivilege(id, "jcr:write")) {
			throw PermissionDeniedException.forNodeAndPrivilege(id, "Write");
		}
	}
}
