package com.xebialabs.deployit.core.rest.api;


import java.util.List;

import com.google.common.base.Strings;
import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.SearchParameters;

public class SearchParameterFactory {
    static final long DEFAULT_RESULTS_PER_PAGE = 25L;

	public static SearchParameters createSearchParam(String type, long page, long resultPerPage, final List<PropertyValue> values) {
		SearchParameters searchParam = new SearchParameters();

		if (type != null && !type.trim().isEmpty()) {
			searchParam.setType(Type.valueOf(type));
		}

		// If not given, are default to 0.
		searchParam.setPage(page);
		// If different from 0 then set it; 0 means default, negative will mean 'all'.
		if (resultPerPage > 0) {
			searchParam.setResultsPerPage(resultPerPage);
		} else if (resultPerPage == 0) {
            searchParam.setResultsPerPage(DEFAULT_RESULTS_PER_PAGE);
        }

		for (PropertyValue value : values) {
			searchParam.addProperty(value.getKey(), value.getValue());
		}

		return searchParam;
	}

	public static SearchParameters createSearchParam(String typeName, long page, long resultPerPage, final List<PropertyValue> values, final String parent, final String id) {
		SearchParameters searchParam = createSearchParam(typeName, page, resultPerPage, values);
		if (isNotBlank(parent)) {
			searchParam.setParent(parent);
		}
		if (isNotBlank(id)) {
			searchParam.setName(id);
		}
		return searchParam;
	}

	private static boolean isNotBlank(String parent) {
		return !Strings.nullToEmpty(parent).trim().isEmpty();
	}
}
