package com.xebialabs.deployit.core.rest.api.reports.widgets;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;

import com.google.common.base.Function;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.Report.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive.TaskCallback;

public class DeploymentTrendsWidget extends DashboardWidgetBase {
	
	private DeploymentTrendsWidget(final TaskArchive taskArchive) {
		this.taskArchive = taskArchive;
	}

	public final static Widget getInstance(final TaskArchive taskArchive) {
		return new DeploymentTrendsWidget(taskArchive) ;
	};
	
	@Override
	public final Report getReport(Date begin, Date end) {
		Map<String, TaskStateData> taskStates = groupTasksByStateAndDate(begin, end);
		return generateReportData(taskStates);
	}

	private Report generateReportData(Map<String, TaskStateData> taskStates) {
		final Report report = new Report();
		DecimalFormat decimalFormat = new DecimalFormat("#.##",DecimalFormatSymbols.getInstance(Locale.ENGLISH));
		for (String month : taskStates.keySet()) {
			TaskStateData stateData = taskStates.get(month);
			ReportLine line = report.addLine();
			line.addValue("month", month);
			line.addValue("noOfSuccessfulDeployments", stateData.getNoOfSuccessfulDeployments().toString());
			line.addValue("noOfAbortedDeployments", stateData.getNoOfAbortedDeployments().toString());
			line.addValue("noOfFailedDeployments", stateData.getNoOfFailedDeployments().toString());
			long totalTasks = stateData.getTotalTasks();
			line.addValue("percentageSuccessfulDeployments", decimalFormat.format(getPercentage(stateData.getNoOfSuccessfulDeployments().get(), totalTasks)));
		}
		return report;
	}

	/**
	 * Groups only completed tasks by state. Ignores the middle states like EXECUTING or PENDING.
	 * 
	 */
	private Map<String, TaskStateData> groupTasksByStateAndDate(final Date begin, Date end) {
		final Map<String, TaskStateData> stateDataMap = initializeMap(begin, end, new Function<String, TaskStateData>() {
			public TaskStateData apply(String input) {
				return new TaskStateData();
			}
		});

		ArchivedTaskSearchParameters params = new ArchivedTaskSearchParameters().createdBetween(begin.getCalendar(), end.getCalendar());

		taskArchive.searchTasksWithoutLoadingSteps(params, new TaskCallback() {
			public void doWithTask(DeploymentTaskInfo task) {
				String month = monthFormat.format(task.getCompletionDate().getTime());
				stateDataMap.get(month).addTask(task);
			}
		});
		return stateDataMap;
	}
}
