package com.xebialabs.deployit.core.rest.resteasy;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

import com.xebialabs.deployit.core.api.resteasy.CustomMediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.Report.ReportLine;
import org.springframework.stereotype.Component;

@Provider
@Component
@Produces(CustomMediaType.TEXT_CSV)
public class CsvMessageProvider implements MessageBodyWriter<Object> {

	private static final String CSV_SEPERATOR = "\u002C";
	private static final String LINE_SEPERATOR = "\n";

	@Override
	public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return -1;
	}

	@Override
	public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
		return type.isAssignableFrom(Report.class) && mediaType.getType().equals("text")
				&& mediaType.getSubtype().equals("csv");
	}

	@Override
	public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, java.lang.Object> httpHeaders, OutputStream entityStream) throws IOException,
			WebApplicationException {

		logger.debug("Entering CsvMessageProvider...");
		String csvFormat = convertReportToCsvFormat((Report) t);
		entityStream.write(csvFormat.getBytes());
	}

	private String convertReportToCsvFormat(Report report) {
		StringBuilder data = new StringBuilder();
		List<ReportLine> reportLines = report.getLines();
		if(reportLines.size() > 0) {
			appendReportHeader(data, reportLines);
			appendReportRows(data, reportLines);
		}
		return data.toString();
	}

	private void appendReportHeader(StringBuilder data, List<ReportLine> reportLines) {
		ReportLine firstReportLine = reportLines.iterator().next();
		if (firstReportLine != null) {
			Map<String, Object> map = firstReportLine.getValues();
			Iterator<String> iterator = new TreeSet<String>(map.keySet()).iterator();
			for (Iterator<String> keyIterator = iterator; keyIterator.hasNext();) {
				String eachHeaderKey = keyIterator.next();
				data.append(encloseInQuotes(eachHeaderKey));
				if (keyIterator.hasNext()) {
					data.append(CSV_SEPERATOR);
				}
			}
			data.append(LINE_SEPERATOR);
		}
	}

	private String encloseInQuotes(String eachKey) {
		return "\"" + eachKey + "\"";
	}

	private void appendReportRows(StringBuilder data, List<ReportLine> reportLines) {
		for (Iterator<ReportLine> rowIter = reportLines.iterator(); rowIter.hasNext();) {
			ReportLine reportLine = (ReportLine) rowIter.next();
			appendReportRow(data, reportLine);
			if (rowIter.hasNext()) {
				data.append(LINE_SEPERATOR);
			}
		}
	}

	private void appendReportRow(StringBuilder data, ReportLine reportLine) {
		Map<String, Object> values = new TreeMap<String, Object>(reportLine.getValues());
		// Loop through Columns
		for (Iterator<Map.Entry<String, Object>> columnIter = values.entrySet().iterator(); columnIter.hasNext();) {
			Map.Entry<String, Object> entry = columnIter.next();
			data.append(encloseInQuotes(entry.getValue().toString()));

			if (columnIter.hasNext()) {
				data.append(CSV_SEPERATOR);
			}
		}
	}

	private static Logger logger = LoggerFactory.getLogger(CsvMessageProvider.class);
}
