package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.io.TemporaryFiles;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.security.SecurityUtils;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;

/**
 * Opens and closes Jcr Sessions and NodeReaderContexts. If an exception occurs, the postProcess isn't called, but the ClosingExceptionMapper cleans up after us in that case.
 */
@Provider
@Component
@ServerInterceptor
public class OpenJcrSessionDuringRequestInterceptor implements PreProcessInterceptor, PostProcessInterceptor {

	@Override
	public void postProcess(ServerResponse response) {
		logger.trace("Logging out...");
		JcrTemplateHolder.get().logout();
		NodeReaderContext.get().release();
        SecurityUtils.clearContext();
		TemporaryFiles.clear();
	}

	@Override
	public ServerResponse preProcess(HttpRequest request, ResourceMethod method) throws Failure, WebApplicationException {
		JcrTemplateHolder.get().login();
		NodeReaderContext.get().hold();
		return null;
	}

	private static final Logger logger = LoggerFactory.getLogger(OpenJcrSessionDuringRequestInterceptor.class);
}
