package com.xebialabs.deployit.core.rest.api.reports;


import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import com.xebialabs.deployit.task.archive.JcrTaskArchive.TaskCallback;

public class TaskReport extends TaskArchiveReport {

    public TaskReport(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report() {
        final Report report = new Report();
        taskArchive.searchTasksWithoutLoadingSteps(getSearchParameters(), new TaskCallback() {
            public void doWithTask(ArchivedTask task) {
                final Report.ReportLine line = report.addLine();
                line.addValue("taskId", task.getId());
                line.addValue("user", task.getOwner());
                line.addValue("status", task.getState().name());
                line.addValue("startDate", ReportUtils.FORMATTER.print(task.getStartDate()));
                line.addValue("completionDate", ReportUtils.FORMATTER.print(task.getCompletionDate()));
                line.addValue("package", task.getMetadata().get("application") + "/" + task.getMetadata().get("version"));
                line.addValue("environment", task.getMetadata().get("environment"));
                line.addValue("type", getTaskType(task));
            }
        });

        return report;
    }

    private static String getTaskType(ArchivedTask task) {
        String taskType = "Unknown";
        switch (TaskType.valueOf(task.getMetadata().get("taskType"))) {
            case INITIAL:
                taskType = "Initial";
                break;
            case UPGRADE:
                taskType = "Update";
                break;
            case UNDEPLOY:
                taskType = "Undeployment";
                break;
            case ROLLBACK:
                taskType = "Rollback";
                break;
        }
        return taskType;
    }
}
