package com.xebialabs.deployit.core.rest.api.reports.widgets;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

import com.google.common.base.Function;

import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.collect.Maps.newLinkedHashMap;

abstract class DashboardWidgetBase extends TaskArchiveReport implements Widget {

    final DateTimeFormatter monthFormat = org.joda.time.format.DateTimeFormat.forPattern("MMM").withLocale(Locale.ENGLISH);

    protected DashboardWidgetBase(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    protected final static double getPercentage(final double numOfTasksInAState, final double totalTasks) {
        checkArgument(numOfTasksInAState <= totalTasks,
                "Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :"
                        + numOfTasksInAState + "totalDeployment:" + totalTasks);
        return (totalTasks == 0) ? 0 : (numOfTasksInAState / totalTasks ) * 100;
    }

    final static String formatToMinsAndSecs(final long millis) {
        final long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis));
        String seconds = String.valueOf(secs);
        if(secs < 10) {
            seconds = "0" + seconds;
        }
        return String.format("%d:%s", TimeUnit.MILLISECONDS.toMinutes(millis), seconds);
    }

    protected final static String formatToSecs(final long millis) {
        final long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        return String.format("%d", seconds);
    }

    protected final static String formatToMins(final long millis) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        final long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(minutes);
        if (seconds >= 30) {
            minutes++;
        }
        return String.format("%d", minutes);
    }

    protected final static String formatToHours(final long millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        final long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(hours);
        if (minutes >= 30) {
            hours++;
        }
        return String.format("%d", hours);
    }

    protected <T> Map<String, T> initializeMap(DateTime begin, DateTime end, Function<String, T> f) {
        Map<String, T> groupedTasks = newLinkedHashMap();
        final DateTime start = begin.withDayOfMonth(1);
        final DateTime endMonth = end.withDayOfMonth(1);
        for (DateTime month = start; month.isBefore(endMonth) || month.equals(endMonth); month = month.plusMonths(1)) {
            String mnth = monthFormat.print(month);
            groupedTasks.put(mnth, f.apply(mnth));
        }

        return groupedTasks;
    }

}
