/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

abstract class DashboardWidgetBase
extends TaskArchiveReport
implements Widget {
    final DateTimeFormatter monthFormat = DateTimeFormat.forPattern((String)"MMM").withLocale(Locale.ENGLISH);

    protected DashboardWidgetBase(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    protected static final double getPercentage(double numOfTasksInAState, double totalTasks) {
        Preconditions.checkArgument((numOfTasksInAState <= totalTasks ? 1 : 0) != 0, (Object)("Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :" + numOfTasksInAState + "totalDeployment:" + totalTasks));
        return totalTasks == 0.0 ? 0.0 : numOfTasksInAState / totalTasks * 100.0;
    }

    static final String formatToMinsAndSecs(long millis) {
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis));
        String seconds = String.valueOf(secs);
        if (secs < 10L) {
            seconds = "0" + seconds;
        }
        return String.format("%d:%s", TimeUnit.MILLISECONDS.toMinutes(millis), seconds);
    }

    protected static final String formatToSecs(long millis) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        return String.format("%d", seconds);
    }

    protected static final String formatToMins(long millis) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(minutes);
        if (seconds >= 30L) {
            ++minutes;
        }
        return String.format("%d", minutes);
    }

    protected static final String formatToHours(long millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(hours);
        if (minutes >= 30L) {
            ++hours;
        }
        return String.format("%d", hours);
    }

    protected <T> Map<String, T> initializeMap(DateTime begin, DateTime end, Function<String, T> f) {
        LinkedHashMap groupedTasks = Maps.newLinkedHashMap();
        DateTime start = begin.withDayOfMonth(1);
        DateTime endMonth = end.withDayOfMonth(1);
        DateTime month = start;
        while (month.isBefore((ReadableInstant)endMonth) || month.equals((Object)endMonth)) {
            String mnth = this.monthFormat.print((ReadableInstant)month);
            groupedTasks.put(mnth, f.apply((Object)mnth));
            month = month.plusMonths(1);
        }
        return groupedTasks;
    }
}

