/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import com.xebialabs.deployit.task.archive.TaskCallback;
import java.util.List;
import org.joda.time.ReadableInstant;

public class TaskReport
extends TaskArchiveReport {
    public TaskReport(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report() {
        final Report report = new Report();
        this.taskArchive.searchTasksWithoutLoadingSteps(this.getSearchParameters().includeMainIfDependencyMatches(), new TaskCallback(){

            public void doWithTask(ArchivedTask task) {
                Report.ReportLine line = report.addLine();
                line.addValue("taskId", (Object)task.getId());
                line.addValue("user", (Object)task.getOwner());
                line.addValue("status", (Object)task.getState().name());
                line.addValue("startDate", (Object)ReportUtils.FORMATTER.print((ReadableInstant)task.getStartDate()));
                line.addValue("completionDate", (Object)ReportUtils.FORMATTER.print((ReadableInstant)task.getCompletionDate()));
                line.addValue("package", (Object)this.buildPackageLabel(task));
                line.addValue("environment", (Object)TaskMetadata.getMetadata((ArchivedTask)task, (String)"environment"));
                line.addValue("environmentId", (Object)TaskMetadata.getMetadata((ArchivedTask)task, (String)"environment_id"));
                line.addValue("environmentIdWithoutRoot", (Object)TaskMetadata.getMetadata((ArchivedTask)task, (String)"environment_id").split("/", 2)[1]);
                line.addValue("type", (Object)TaskReport.getTaskType(task));
            }

            String buildPackageLabel(ArchivedTask task) {
                StringBuilder builder = new StringBuilder();
                this.appendLabel(builder, TaskMetadata.getMetadata((ArchivedTask)task, (String)"application"), TaskMetadata.getMetadata((ArchivedTask)task, (String)"version"));
                for (TaskPackageDependency dependency : Lists.reverse((List)task.getPackageDependencies())) {
                    builder.append(", ");
                    this.appendLabel(builder, dependency.getApplication(), dependency.getVersion());
                }
                return builder.toString();
            }

            void appendLabel(StringBuilder builder, String application, String version) {
                builder.append(application);
                builder.append("/");
                builder.append(version);
            }
        });
        return report;
    }

    private static String getTaskType(ArchivedTask task) {
        String taskType = "Unknown";
        switch (TaskType.valueOf((String)TaskMetadata.getMetadata((ArchivedTask)task, (String)"taskType"))) {
            case INITIAL: {
                taskType = "Initial";
                break;
            }
            case UPGRADE: {
                taskType = "Update";
                break;
            }
            case UNDEPLOY: {
                taskType = "Undeployment";
                break;
            }
            case ROLLBACK: {
                taskType = "Rollback";
                break;
            }
        }
        return taskType;
    }
}

