/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.task.archive.DeploymentResult;
import com.xebialabs.deployit.task.archive.TaskArchive;
import com.xebialabs.deployit.task.archive.analytics.ThroughputReportLine;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DeploymentTrendsWidget
extends DashboardWidgetBase {
    private static final String PERCENTAGE_SUCCESSFUL_DEPLOYMENTS = "percentageSuccessfulDeployments";

    public DeploymentTrendsWidget(TaskArchive taskArchive) {
        super(taskArchive);
    }

    @Override
    public final Report getReport(DateTime begin, DateTime end) {
        Collection searchResult = this.taskArchive.throughput(begin, end);
        return this.transformResult(searchResult, begin, end);
    }

    private Report transformResult(Collection<ThroughputReportLine> searchResult, DateTime begin, DateTime end) {
        Report report = new Report();
        if (end.isBefore((ReadableInstant)begin)) {
            return report;
        }
        Map<Integer, Map<Integer, Map<String, Integer>>> searchResultGroupedByYearMonthDeployResult = searchResult.stream().collect(Collectors.groupingBy(ThroughputReportLine::year, Collectors.groupingBy(ThroughputReportLine::monthno, Collectors.groupingBy(ThroughputReportLine::executionState, Collectors.summingInt(ThroughputReportLine::amount)))));
        ReportUtils.getMonthsOfInterval(begin, end).forEach(month -> {
            Map monthDeployResultCount = (Map)searchResultGroupedByYearMonthDeployResult.get(month.getYear());
            int currentMonth = month.monthOfYear().get();
            if (monthDeployResultCount == null) {
                DeploymentTrendsWidget.addReportLine(report, currentMonth);
            } else {
                Map monthAmounts = (Map)monthDeployResultCount.get(currentMonth);
                if (monthAmounts == null) {
                    DeploymentTrendsWidget.addReportLine(report, currentMonth);
                } else {
                    DeploymentTrendsWidget.addReportLine(report, currentMonth, monthAmounts.getOrDefault(DeploymentResult.ROLLBACK.name(), 0), monthAmounts.getOrDefault(DeploymentResult.SUCCESS.name(), 0), monthAmounts.getOrDefault(DeploymentResult.ABORTED.name(), 0), monthAmounts.getOrDefault(DeploymentResult.FAILED.name(), 0), monthAmounts.getOrDefault(DeploymentResult.TOTAL.name(), 0));
                }
            }
        });
        return report;
    }

    private static void addReportLine(Report report, Integer month) {
        DeploymentTrendsWidget.addReportLine(report, month, 0, 0, 0, 0, 0);
    }

    private static void addReportLine(Report report, Integer month, int rollbackDeployments, int successDeployments, int abortedDeployments, int failedDeployments, int totalDeployments) {
        ReportLine line = report.addLine();
        line.addValue("month", (Object)DeploymentTrendsWidget.getFormattedMonth(month));
        line.addValue("noOfRollbacks", (Object)String.valueOf(rollbackDeployments));
        line.addValue("noOfSuccessfulDeployments", (Object)String.valueOf(successDeployments));
        line.addValue("noOfAbortedDeployments", (Object)String.valueOf(abortedDeployments));
        line.addValue("noOfFailedDeployments", (Object)String.valueOf(failedDeployments));
        line.addValue(PERCENTAGE_SUCCESSFUL_DEPLOYMENTS, (Object)DeploymentTrendsWidget.getFormattedPercentage(successDeployments, totalDeployments));
    }
}

