/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.task.ThreadPoolTaskExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import scala.reflect.ScalaSignature;

@Configuration
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001=\u0011!c\u0015;sK\u0006l\u0017N\\4BaB\u001cuN\u001c4jO*\u00111\u0001B\u0001\u000bo\u0016\u00147o\\2lKR\u001c(BA\u0003\u0007\u0003\u0011\u0011Xm\u001d;\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T!!\u0003\u0006\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!9A\u0004\u0001b\u0001\n\u0003i\u0012!\u0007+I%\u0016\u000bEi\u0018)P\u001f2{6i\u0014(G\u0013\u001e{\u0006KU#G\u0013b+\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019\u0019FO]5oO\"1q\u0005\u0001Q\u0001\ny\t!\u0004\u0016%S\u000b\u0006#u\fU(P\u0019~\u001buJ\u0014$J\u000f~\u0003&+\u0012$J1\u0002Bq!\u000b\u0001C\u0002\u0013\u0005!&\u0001\u0007tsN$X-\\\"p]\u001aLw-F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0004d_:4\u0017n\u001a\u0006\u0003a1\t\u0001\u0002^=qKN\fg-Z\u0005\u0003e5\u0012aaQ8oM&<\u0007B\u0002\u001b\u0001A\u0003%1&A\u0007tsN$X-\\\"p]\u001aLw\r\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003\u0019!\u0017-Z7p]V\t\u0001\b\u0005\u0002\u0012s%\u0011!H\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019a\u0004\u0001)A\u0005q\u00059A-Y3n_:\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\rG>\u0014X\rU8pYNK'0Z\u000b\u0002\u0001B\u0011\u0011#Q\u0005\u0003\u0005J\u00111!\u00138u\u0011\u0019!\u0005\u0001)A\u0005\u0001\u0006i1m\u001c:f!>|GnU5{K\u0002BqA\u0012\u0001C\u0002\u0013\u0005q(\u0001\tlK\u0016\u0004\u0018\t\\5wKN+7m\u001c8eg\"1\u0001\n\u0001Q\u0001\n\u0001\u000b\u0011c[3fa\u0006c\u0017N^3TK\u000e|g\u000eZ:!\u0011\u001dQ\u0005A1A\u0005\u0002}\n1\"\\1y!>|GnU5{K\"1A\n\u0001Q\u0001\n\u0001\u000bA\"\\1y!>|GnU5{K\u0002BqA\u0014\u0001C\u0002\u0013\u0005q(A\u0007rk\u0016,XmQ1qC\u000eLG/\u001f\u0005\u0007!\u0002\u0001\u000b\u0011\u0002!\u0002\u001dE,X-^3DCB\f7-\u001b;zA!)!\u000b\u0001C\u0001'\u0006\u0011r/\u001a2t_\u000e\\W\r^:Fq\u0016\u001cW\u000f^8s+\u0005!\u0006CA+Y\u001b\u00051&BA,\t\u0003\u0011!\u0018m]6\n\u0005e3&A\u0006+ie\u0016\fG\rU8pYR\u000b7o[#yK\u000e,Ho\u001c:)\tE[v\r\u001b\t\u00039\u0016l\u0011!\u0018\u0006\u0003=~\u000b!\"\u00198o_R\fG/[8o\u0015\t\u0001\u0017-A\u0004d_:$X\r\u001f;\u000b\u0005\t\u001c\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0011\f1a\u001c:h\u0013\t1WL\u0001\u0003CK\u0006t\u0017!\u00043fgR\u0014x._'fi\"|G-I\u0001j\u0003!\u0019\b.\u001e;e_^t\u0007\"B6\u0001\t\u0003a\u0017aG<fEN|7m[3ugN\u001b\u0007.\u001a3vY\u0016\u0014X\t_3dkR|'/F\u0001n!\tq7/D\u0001p\u0015\t\u0001\u0018/\u0001\u0006d_:\u001cWO\u001d:f]RT!A\u001d\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003i>\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2fQ\u0011Q7l\u001a5\t\u000b]\u0004A\u0011\u0001=\u0002'],'m]8dW\u0016$8oU2iK\u0012,H.\u001a:\u0015\u000be\f\t!!\b\u0011\u0005itX\"A>\u000b\u0005Ad(BA?b\u0003)\u00198\r[3ek2LgnZ\u0005\u0003\u007fn\u0014qcQ8oGV\u0014(/\u001a8u)\u0006\u001c8nU2iK\u0012,H.\u001a:\t\r\u0005\ra\u000f1\u0001U\u0003Y!\bN]3bIB{w\u000e\u001c+bg.,\u00050Z2vi>\u0014\b\u0006CA\u0001\u0003\u000f\tI\"a\u0007\u0011\t\u0005%\u0011QC\u0007\u0003\u0003\u0017Q1AXA\u0007\u0015\u0011\ty!!\u0005\u0002\u000f\u0019\f7\r^8ss*\u0019\u00111C1\u0002\u000b\t,\u0017M\\:\n\t\u0005]\u00111\u0002\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f\u0013A\u0015\u0005\u0007\u0003?1\b\u0019A7\u00021M\u001c\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u000b\u0005\u0002\u001e\u0005\u001d\u0011\u0011DA\u0012C\u0005Y\u0007f\u0001<\u0002(A!\u0011\u0011BA\u0015\u0013\u0011\tY#a\u0003\u0003\u0013\u0005+Ho\\<je\u0016$\u0007F\u0001<\\Q\r\u0001\u0011\u0011\u0007\t\u00049\u0006M\u0012bAA\u001b;\ni1i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public class StreamingAppConfig {
    private final String THREAD_POOL_CONFIG_PREFIX;
    private final Config systemConfig = ConfigFactory.load((String)"system.conf");
    private final boolean daemon = this.systemConfig().getBoolean(this.THREAD_POOL_CONFIG_PREFIX() + "daemon");
    private final int corePoolSize = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "core-pool-size");
    private final int keepAliveSeconds = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "keep-alive-seconds");
    private final int maxPoolSize = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "max-pool-size");
    private final int queueCapacity = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "queue-capacity");

    public String THREAD_POOL_CONFIG_PREFIX() {
        return this.THREAD_POOL_CONFIG_PREFIX;
    }

    public Config systemConfig() {
        return this.systemConfig;
    }

    public boolean daemon() {
        return this.daemon;
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }

    public int keepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public int queueCapacity() {
        return this.queueCapacity;
    }

    /*
     * WARNING - void declaration
     */
    @Bean(destroyMethod="shutdown")
    public ThreadPoolTaskExecutor websocketsExecutor() {
        void var1_1;
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize());
        threadPoolTaskExecutor.setDaemon(this.daemon());
        threadPoolTaskExecutor.setKeepAliveSeconds(this.keepAliveSeconds());
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity());
        threadPoolTaskExecutor.setThreadNamePrefix("Websockets-Executor-");
        return var1_1;
    }

    @Bean(destroyMethod="shutdown")
    public ScheduledExecutorService websocketsSchedulerExecutor() {
        return Executors.newScheduledThreadPool(this.corePoolSize(), (ThreadFactory)new CustomizableThreadFactory("Websockets-Scheduler-"));
    }

    @Bean
    @Autowired
    public ConcurrentTaskScheduler websocketsScheduler(@Qualifier(value="websocketsExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, @Qualifier(value="websocketsSchedulerExecutor") ScheduledExecutorService scheduledExecutorService) {
        return new ConcurrentTaskScheduler((Executor)threadPoolTaskExecutor, scheduledExecutorService);
    }

    public StreamingAppConfig() {
        this.THREAD_POOL_CONFIG_PREFIX = "xl.deploy.websockets.threadpool.";
    }
}

