/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.xebialabs.deployit.core.websockets.ThreadPoolTaskExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import scala.reflect.ScalaSignature;

@Configuration
@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001=\u0011!c\u0015;sK\u0006l\u0017N\\4BaB\u001cuN\u001c4jO*\u00111\u0001B\u0001\u000bo\u0016\u00147o\\2lKR\u001c(BA\u0003\u0007\u0003\u0011\u0011Xm\u001d;\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T!!\u0003\u0006\u0002\u0011\u0011,\u0007\u000f\\8zSRT!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!9A\u0004\u0001b\u0001\n\u0003i\u0012!\u0007+I%\u0016\u000bEi\u0018)P\u001f2{6i\u0014(G\u0013\u001e{\u0006KU#G\u0013b+\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019\u0019FO]5oO\"1q\u0005\u0001Q\u0001\ny\t!\u0004\u0016%S\u000b\u0006#u\fU(P\u0019~\u001buJ\u0014$J\u000f~\u0003&+\u0012$J1\u0002Bq!\u000b\u0001C\u0002\u0013\u0005!&\u0001\u0007tsN$X-\\\"p]\u001aLw-F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0004d_:4\u0017n\u001a\u0006\u0003a1\t\u0001\u0002^=qKN\fg-Z\u0005\u0003e5\u0012aaQ8oM&<\u0007B\u0002\u001b\u0001A\u0003%1&A\u0007tsN$X-\\\"p]\u001aLw\r\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003\u0019!\u0017-Z7p]V\t\u0001\b\u0005\u0002\u0012s%\u0011!H\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019a\u0004\u0001)A\u0005q\u00059A-Y3n_:\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\rG>\u0014X\rU8pYNK'0Z\u000b\u0002\u0001B\u0011\u0011#Q\u0005\u0003\u0005J\u00111!\u00138u\u0011\u0019!\u0005\u0001)A\u0005\u0001\u0006i1m\u001c:f!>|GnU5{K\u0002BqA\u0012\u0001C\u0002\u0013\u0005q(\u0001\tlK\u0016\u0004\u0018\t\\5wKN+7m\u001c8eg\"1\u0001\n\u0001Q\u0001\n\u0001\u000b\u0011c[3fa\u0006c\u0017N^3TK\u000e|g\u000eZ:!\u0011\u001dQ\u0005A1A\u0005\u0002}\n1\"\\1y!>|GnU5{K\"1A\n\u0001Q\u0001\n\u0001\u000bA\"\\1y!>|GnU5{K\u0002BqA\u0014\u0001C\u0002\u0013\u0005q(A\u0007rk\u0016,XmQ1qC\u000eLG/\u001f\u0005\u0007!\u0002\u0001\u000b\u0011\u0002!\u0002\u001dE,X-^3DCB\f7-\u001b;zA!)!\u000b\u0001C\u0001'\u0006\u0011r/\u001a2t_\u000e\\W\r^:Fq\u0016\u001cW\u000f^8s+\u0005!\u0006CA+X\u001b\u00051&BA\u0002\u0007\u0013\tAfK\u0001\fUQJ,\u0017\r\u001a)p_2$\u0016m]6Fq\u0016\u001cW\u000f^8sQ\u0011\t&LZ4\u0011\u0005m#W\"\u0001/\u000b\u0005us\u0016AC1o]>$\u0018\r^5p]*\u0011q\fY\u0001\bG>tG/\u001a=u\u0015\t\t'-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0019\u0017aA8sO&\u0011Q\r\u0018\u0002\u0005\u0005\u0016\fg.A\u0007eKN$(o\\=NKRDw\u000eZ\u0011\u0002Q\u0006A1\u000f[;uI><h\u000eC\u0003k\u0001\u0011\u00051.A\u000exK\n\u001cxnY6fiN\u001c6\r[3ek2,'/\u0012=fGV$xN]\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u000bG>t7-\u001e:sK:$(BA9#\u0003\u0011)H/\u001b7\n\u0005Mt'\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\"\"\u0011N\u00174h\u0011\u00151\b\u0001\"\u0001x\u0003M9XMY:pG.,Go]*dQ\u0016$W\u000f\\3s)\u0011Ax0a\u0007\u0011\u0005elX\"\u0001>\u000b\u0005=\\(B\u0001?a\u0003)\u00198\r[3ek2LgnZ\u0005\u0003}j\u0014qcQ8oGV\u0014(/\u001a8u)\u0006\u001c8nU2iK\u0012,H.\u001a:\t\r\u0005\u0005Q\u000f1\u0001U\u0003Y!\bN]3bIB{w\u000e\u001c+bg.,\u00050Z2vi>\u0014\bfB@\u0002\u0006\u0005]\u0011\u0011\u0004\t\u0005\u0003\u000f\t\u0019\"\u0004\u0002\u0002\n)\u0019Q,a\u0003\u000b\t\u00055\u0011qB\u0001\bM\u0006\u001cGo\u001c:z\u0015\r\t\t\u0002Y\u0001\u0006E\u0016\fgn]\u0005\u0005\u0003+\tIAA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\n!\u000b\u0003\u0004\u0002\u001eU\u0004\r\u0001\\\u0001\u0019g\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0006CA\u000e\u0003\u000b\t9\"!\t\"\u0003)D3!^A\u0013!\u0011\t9!a\n\n\t\u0005%\u0012\u0011\u0002\u0002\n\u0003V$xn^5sK\u0012D#!\u001e.)\u0007\u0001\ty\u0003E\u0002\\\u0003cI1!a\r]\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class StreamingAppConfig {
    private final String THREAD_POOL_CONFIG_PREFIX;
    private final Config systemConfig = ConfigFactory.load((String)"system.conf");
    private final boolean daemon = this.systemConfig().getBoolean(this.THREAD_POOL_CONFIG_PREFIX() + "daemon");
    private final int corePoolSize = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "core-pool-size");
    private final int keepAliveSeconds = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "keep-alive-seconds");
    private final int maxPoolSize = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "max-pool-size");
    private final int queueCapacity = this.systemConfig().getInt(this.THREAD_POOL_CONFIG_PREFIX() + "queue-capacity");

    public String THREAD_POOL_CONFIG_PREFIX() {
        return this.THREAD_POOL_CONFIG_PREFIX;
    }

    public Config systemConfig() {
        return this.systemConfig;
    }

    public boolean daemon() {
        return this.daemon;
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }

    public int keepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public int queueCapacity() {
        return this.queueCapacity;
    }

    /*
     * WARNING - void declaration
     */
    @Bean(destroyMethod="shutdown")
    public ThreadPoolTaskExecutor websocketsExecutor() {
        void var1_1;
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize());
        threadPoolTaskExecutor.setDaemon(this.daemon());
        threadPoolTaskExecutor.setKeepAliveSeconds(this.keepAliveSeconds());
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity());
        threadPoolTaskExecutor.setThreadNamePrefix("Websockets-Executor-");
        return var1_1;
    }

    @Bean(destroyMethod="shutdown")
    public ScheduledExecutorService websocketsSchedulerExecutor() {
        return Executors.newScheduledThreadPool(this.corePoolSize(), (ThreadFactory)new CustomizableThreadFactory("Websockets-Scheduler-"));
    }

    @Bean
    @Autowired
    public ConcurrentTaskScheduler websocketsScheduler(@Qualifier(value="websocketsExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, @Qualifier(value="websocketsSchedulerExecutor") ScheduledExecutorService scheduledExecutorService) {
        return new ConcurrentTaskScheduler((Executor)threadPoolTaskExecutor, scheduledExecutorService);
    }

    public StreamingAppConfig() {
        this.THREAD_POOL_CONFIG_PREFIX = "xl.deploy.websockets.threadpool.";
    }
}

