/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.ChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.repository.ChangeSet;
import java.util.List;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001=\u0011qcV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3t'\u0016tG-\u001a:\u000b\u0005\r!\u0011AC<fEN|7m[3ug*\u0011QAB\u0001\u0005e\u0016\u001cHO\u0003\u0002\b\u0011\u0005!1m\u001c:f\u0015\tI!\"\u0001\u0005eKBdw._5u\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aD\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0010[\u0016\u001c8/Y4f)\u0016l\u0007\u000f\\1uKB\u0011\u0011DI\u0007\u00025)\u00111\u0004H\u0001\u0005g&l\u0007O\u0003\u0002\u001e=\u0005IQ.Z:tC\u001eLgn\u001a\u0006\u0003?\u0001\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002C\u0005\u0019qN]4\n\u0005\rR\"!F*j[BlUm]:bO&tw\rV3na2\fG/\u001a\u0015\u0003-\u0015\u0002\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002+W\u00059a-Y2u_JL(B\u0001\u0017\u001f\u0003\u0015\u0011W-\u00198t\u0013\tqsEA\u0005BkR|w/\u001b:fI\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"\"A\r\u001b\u0011\u0005M\u0002Q\"\u0001\u0002\t\u000b]y\u0003\u0019\u0001\r)\u0005Q*\u0003\"B\u001c\u0001\t\u0013A\u0014AC4fi\"+\u0017\rZ3sgV\t\u0011\b\u0005\u0003;\u0003\u0012\u0003bBA\u001e@!\ta$#D\u0001>\u0015\tqd\"\u0001\u0004=e>|GOP\u0005\u0003\u0001J\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\ri\u0015\r\u001d\u0006\u0003\u0001J\u0001\"AO#\n\u0005\u0019\u001b%AB*ue&tw\rC\u0003I\u0001\u0011%\u0011*\u0001\to_RLg-_%g\u001d>$X)\u001c9usR\u0019!*\u0014+\u0011\u0005EY\u0015B\u0001'\u0013\u0005\u0011)f.\u001b;\t\u000b9;\u0005\u0019A(\u0002\u0011\u0015tG\r]8j]R\u0004\"\u0001\u0015*\u000e\u0003ES!a\u0001\u0004\n\u0005M\u000b&AE,fEN{7m[3u\u000b:$\u0007o\\5oiNDQ!V$A\u0002Y\u000b1aY5ta\t9\u0016\rE\u0002Y;~k\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0001\fG\u0002\u0001\u0003\nER\u000b\t\u0011!A\u0003\u0002\r\u00141a\u0018\u00132#\t!w\r\u0005\u0002\u0012K&\u0011aM\u0005\u0002\b\u001d>$\b.\u001b8h!\t\t\u0002.\u0003\u0002j%\t\u0019\u0011I\\=\t\u000b-\u0004A\u0011\u00017\u0002/M,g\u000eZ\"j\u0007\"\fgnZ3TKRlUm]:bO\u0016\u001cHC\u0001&n\u0011\u0015q'\u000e1\u0001p\u0003\u0015)g/\u001a8u!\t\u00018/D\u0001r\u0015\t\u0011h!\u0001\u0004fm\u0016tGo]\u0005\u0003iF\u0014ab\u00115b]\u001e,7+\u001a;Fm\u0016tG\u000f\u000b\u0002kmB\u0011qO`\u0007\u0002q*\u0011\u0011P_\u0001\u0006iJ\u0012Wo\u001d\u0006\u0003wr\f\u0001B[1wC\u0012,H-\u001a\u0006\u0002{\u0006\u0011a\u000e\\\u0005\u0003\u007fb\u0014\u0011bU;cg\u000e\u0014\u0018NY3\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006\u0005\u0001cn\u001c;jMf\f%m\\;u\u001b\u0006Lg\u000e^3oC:\u001cW-T8eK\u000eC\u0017M\\4f)\rQ\u0015q\u0001\u0005\t\u0003\u0013\t\t\u00011\u0001\u0002\f\u00059QM\\1cY\u0016$\u0007cA\t\u0002\u000e%\u0019\u0011q\u0002\n\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011AF:f]\u0012l\u0015-\u001b8uK:\fgnY3Ti\u0006\u0014H/\u001a3\u0015\u0007)\u000b9\u0002C\u0004o\u0003#\u0001\r!!\u0007\u0011\t\u0005m\u0011qE\u0007\u0003\u0003;Q1A\\A\u0010\u0015\u0011\t\t#a\t\u0002\u0007M\u0004\u0018NC\u0002\u0002&!\ta!\u001a8hS:,\u0017\u0002BA\u0015\u0003;\u0011Q#T1j]R,g.\u00198dKN#\u0018M\u001d;Fm\u0016tG\u000fK\u0002\u0002\u0012YDq!a\f\u0001\t\u0003\t\t$\u0001\ftK:$W*Y5oi\u0016t\u0017M\\2f'R|\u0007\u000f]3e)\rQ\u00151\u0007\u0005\b]\u00065\u0002\u0019AA\u001b!\u0011\tY\"a\u000e\n\t\u0005e\u0012Q\u0004\u0002\u0015\u001b\u0006Lg\u000e^3oC:\u001cWm\u0015;pa\u00163XM\u001c;)\u0007\u00055b\u000fK\u0002\u0001\u0003\u007f\u0001B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000br\u0012AC:uKJ,w\u000e^=qK&!\u0011\u0011JA\"\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    private Map<String, Object> getHeaders() {
        String currentUser = SecurityContextHolder.getContext().getAuthentication().getName();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)currentUser)}));
    }

    private void notifyIfNotEmpty(WebSocketEndpoints endpoint, List<?> cis) {
        block0: {
            if (!ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(cis).nonEmpty()) break block0;
            this.messageTemplate.convertAndSend((Object)endpoint.getName(), cis, ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders()));
        }
    }

    @Subscribe
    public void sendCiChangeSetMessages(ChangeSetEvent event) {
        ChangeSet changeset = event.getChangeset();
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, changeset.getCreateCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, changeset.getUpdateCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, changeset.getDeleteCiIds());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, changeset.getRenameCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, changeset.getMoveCis());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, changeset.getCopyCis());
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled), ImplicitConversions$.MODULE$.map$u0020AsJavaMap(this.getHeaders()));
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

