/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.CredentialService;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.validator.UniqueDefaultCredentialValidator;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemProperties;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001=\u0011Qc\u0011:fI\u0016tG/[1m'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0005\u00151\u0011\u0001\u0002:fgRT!a\u0002\u0005\u0002\t\r|'/\u001a\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u00192\u0001\u0001\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001c\u001b\u0005Q\"BA\u0002\u0007\u0013\ta\"DA\tDe\u0016$WM\u001c;jC2\u001cVM\u001d<jG\u0016D\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u001bI\u00164\u0017-\u001e7u\u0007J,G-\u001a8uS\u0006dg+\u00197jI\u0006$xN\u001d\t\u0003A\rj\u0011!\t\u0006\u0003E\u0019\t\u0011B^1mS\u0012\fGo\u001c:\n\u0005\u0011\n#\u0001I+oSF,X\rR3gCVdGo\u0011:fI\u0016tG/[1m-\u0006d\u0017\u000eZ1u_JD\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0012e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\t\u0003)\u0011X\r]8tSR|'/_\u0005\u0003Y%\u0012\u0011CU3q_NLGo\u001c:z'\u0016\u0014h/[2f\u0011!\u0011\u0003A!A!\u0002\u0013q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003g!\tqa]3sm&\u001cW-\u0003\u00026a\tIa+\u00197jI\u0006$xN\u001d\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\teZD(\u0010\t\u0003u\u0001i\u0011A\u0001\u0005\u0006=Y\u0002\ra\b\u0005\u0006MY\u0002\ra\n\u0005\u0006EY\u0002\rA\f\u0015\u0003m}\u0002\"\u0001Q&\u000e\u0003\u0005S!AQ\"\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002E\u000b\u00069a-Y2u_JL(B\u0001$H\u0003\u0015\u0011W-\u00198t\u0015\tA\u0015*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Q\u0015aA8sO&\u0011A*\u0011\u0002\n\u0003V$xn^5sK\u0012DqA\u0014\u0001C\u0002\u0013\u0005q*\u0001\u0004m_\u001e<WM]\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111+S\u0001\u0006g24GG[\u0005\u0003+J\u0013a\u0001T8hO\u0016\u0014\bBB,\u0001A\u0003%\u0001+A\u0004m_\u001e<WM\u001d\u0011\t\u000be\u0003A\u0011\t.\u0002\r\r\u0014X-\u0019;f)\u0011Y\u0016M\\:\u0011\u0005q{V\"A/\u000b\u0003y\u000bQa]2bY\u0006L!\u0001Y/\u0003\tUs\u0017\u000e\u001e\u0005\u0006Eb\u0003\raY\u0001\u0003S\u0012\u0004\"\u0001Z6\u000f\u0005\u0015L\u0007C\u00014^\u001b\u00059'B\u00015\u000f\u0003\u0019a$o\\8u}%\u0011!.X\u0001\u0007!J,G-\u001a4\n\u00051l'AB*ue&twM\u0003\u0002k;\")q\u000e\u0017a\u0001a\u0006Iam\u001c:dKN\u000bg/\u001a\t\u00039FL!A]/\u0003\u000f\t{w\u000e\\3b]\")A\u000f\u0017a\u0001k\u0006\t2m\u001c8gS\u001e,(/\u0019;j_:LE/Z7\u0011\u0005YdX\"A<\u000b\u0005aL\u0018aA;e[*\u00111A\u001f\u0006\u0003w\"\ta\u0001\u001d7vO&t\u0017BA?x\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\u0005\u0007\u007f\u0002!\t%!\u0001\u0002\rU\u0004H-\u0019;f)\u001dY\u00161AA\u0003\u0003\u000fAQA\u0019@A\u0002\rDQa\u001c@A\u0002ADQ\u0001\u001e@A\u0002UDq!a\u0003\u0001\t\u0013\ti!\u0001\u000bwC2LG-\u0019;f\u0007J,G-\u001a8uS\u0006d7)\u001b\u000b\u00067\u0006=\u0011\u0011\u0003\u0005\u0007_\u0006%\u0001\u0019\u00019\t\rQ\fI\u00011\u0001v\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\taC]3tKR$UMZ1vYR\u001c%/\u001a3f]RL\u0017\r\u001c\u000b\u00027\"\u001a\u0001!a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tH\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003K\tyB\u0001\u0006D_:$(o\u001c7mKJ\u0004")
public class CredentialServiceImpl
implements CredentialService {
    private final UniqueDefaultCredentialValidator defaultCredentialValidator;
    private final RepositoryService repositoryService;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void create(String id, boolean forceSave, ConfigurationItem configurationItem) {
        this.validateCredentialCi(forceSave, configurationItem);
        if (forceSave) {
            this.resetDefaultCredential();
        }
        this.repositoryService.create(new ConfigurationItem[]{configurationItem});
    }

    public void update(String id, boolean forceSave, ConfigurationItem configurationItem) {
        this.validateCredentialCi(forceSave, configurationItem);
        if (forceSave) {
            this.resetDefaultCredential();
        }
        this.repositoryService.update(new ConfigurationItem[]{configurationItem});
    }

    private void validateCredentialCi(boolean forceSave, ConfigurationItem configurationItem) {
        if (!forceSave) {
            try {
                this.defaultCredentialValidator.validate(configurationItem);
            }
            catch (Validator.ValidationsFailedException ex) {
                this.logger().debug(ex.getMessage());
                throw ex;
            }
        }
    }

    private void resetDefaultCredential() {
        HashMap<String, String> properties = new HashMap<String, String>(null){
            {
                this.put("defaultCi", "true");
            }
        };
        ConfigurationItemProperties ciProperties = new ConfigurationItemProperties((Map)properties);
        SearchParameters searchParameters = SearchParametersFactory.createSearchParams((Type)Type.valueOf((String)"credentials.UsernamePasswordCredentials"), (long)0L, (long)-1L, null, null, null, null, null, null, (int)0, (ConfigurationItemProperties)ciProperties);
        String defaultCredentialCiId = (String)((IterableLike)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repositoryService.list(searchParameters)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom())).head();
        ConfigurationItem defaultCredentialCi = this.repositoryService.read(defaultCredentialCiId);
        defaultCredentialCi.setProperty("defaultCi", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.repositoryService.update(new ConfigurationItem[]{defaultCredentialCi});
    }

    @Autowired
    public CredentialServiceImpl(UniqueDefaultCredentialValidator defaultCredentialValidator, RepositoryService repositoryService, Validator validator) {
        this.defaultCredentialValidator = defaultCredentialValidator;
        this.repositoryService = repositoryService;
        this.logger = LoggerFactory.getLogger(CredentialServiceImpl.class);
    }
}

