/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.config.XldSystemConfig$;
import com.xebialabs.deployit.core.rest.converters.CiMessageConverter;
import com.xebialabs.deployit.core.rest.converters.CisMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiJsonMessageBodyReaderWriter;
import com.xebialabs.deployit.core.rest.json.CisJsonMessageBodyReaderWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0006\r\u0001eA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0004[\u0001\t\u0007I\u0011B.\t\r\u0011\u0004\u0001\u0015!\u0003]\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!!\t\u0001\t\u0003\n\u0019C\u0001\u000fXK\n\u001cvnY6fi6+7o]1hK\n\u0013xn[3s\u0007>tg-[4\u000b\u00055q\u0011AC<fEN|7m[3ug*\u0011q\u0002E\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0012%\u0005!1m\u001c:f\u0015\t\u0019B#\u0001\u0005eKBdw._5u\u0015\t)b#A\u0005yK\nL\u0017\r\\1cg*\tq#A\u0002d_6\u001c\u0001a\u0005\u0002\u00015A\u00111\u0004K\u0007\u00029)\u0011QDH\u0001\u000bC:tw\u000e^1uS>t'BA\u0010!\u0003\u0019\u0019wN\u001c4jO*\u0011\u0011EI\u0001\u0007g>\u001c7.\u001a;\u000b\u0005\r\"\u0013aA<fE*\u0011QEJ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq%A\u0002pe\u001eL!!\u000b\u000f\u0003Q\u0005\u00137\u000f\u001e:bGR<VMY*pG.,G/T3tg\u0006<WM\u0011:pW\u0016\u00148i\u001c8gS\u001e,(/\u001a:\u0002;\rL'j]8o\u001b\u0016\u001c8/Y4f\u0005>$\u0017PU3bI\u0016\u0014xK]5uKJ\u0004\"\u0001L\u0018\u000e\u00035R!A\f\b\u0002\t)\u001cxN\\\u0005\u0003a5\u0012QdQ5Kg>tW*Z:tC\u001e,'i\u001c3z%\u0016\fG-\u001a:Xe&$XM\u001d\u0015\u0003\u0003I\u0002\"aM\u001d\u000e\u0003QR!!H\u001b\u000b\u0005Y:\u0014a\u00024bGR|'/\u001f\u0006\u0003q\u0011\nQAY3b]NL!A\u000f\u001b\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AH2jg*\u001bxN\\'fgN\fw-\u001a\"pIf\u0014V-\u00193fe^\u0013\u0018\u000e^3s!\taS(\u0003\u0002?[\tq2)[:Kg>tW*Z:tC\u001e,'i\u001c3z%\u0016\fG-\u001a:Xe&$XM\u001d\u0015\u0003\u0005I\nQ\u0002^1tWN\u001b\u0007.\u001a3vY\u0016\u0014\bC\u0001\"F\u001b\u0005\u0019%B\u0001#%\u0003)\u00198\r[3ek2LgnZ\u0005\u0003\r\u000e\u0013Q\u0002V1tWN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0006B\u0002I\u00172\u0003\"aM%\n\u0005)#$!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005i\u0015aE<fEN|7m[3ugN\u001b\u0007.\u001a3vY\u0016\u0014\bFA\u00023\u0003\u0019a\u0014N\\5u}Q!\u0011kU+X!\t\u0011\u0006!D\u0001\r\u0011\u0015QC\u00011\u0001,Q\t\u0019&\u0007C\u0003<\t\u0001\u0007A\b\u000b\u0002Ve!)\u0001\t\u0002a\u0001\u0003\"\"q\u000bS&MQ\t9&'\u0001\u000fN\u000bN\u001b\u0016iR#`\u0005J{5*\u0012*`\u0007>se)S$`!J+e)\u0013-\u0016\u0003q\u0003\"!\u00182\u000e\u0003yS!a\u00181\u0002\t1\fgn\u001a\u0006\u0002C\u0006!!.\u0019<b\u0013\t\u0019gL\u0001\u0004TiJLgnZ\u0001\u001e\u001b\u0016\u001b6+Q$F?\n\u0013vjS#S?\u000e{eJR%H?B\u0013VIR%YA\u000512m\u001c8gS\u001e,(/Z'fgN\fw-\u001a\"s_.,'\u000f\u0006\u0002h[B\u0011\u0001n[\u0007\u0002S*\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\n!QK\\5u\u0011\u0015qw\u00011\u0001p\u0003!\u0011XmZ5tiJL\bC\u00019w\u001b\u0005\t(BA\u0010s\u0015\t\u0019H/\u0001\u0003tS6\u0004(BA;%\u0003%iWm]:bO&tw-\u0003\u0002xc\n)R*Z:tC\u001e,'I]8lKJ\u0014VmZ5tiJL\u0018\u0001\u00055b]\u0012\u001c\b.Y6f\u0011\u0006tG\r\\3s)\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u000691/\u001e9q_J$(BA@!\u0003\u0019\u0019XM\u001d<fe&\u0019\u00111\u0001?\u0003/\u0011+g-Y;mi\"\u000bg\u000eZ:iC.,\u0007*\u00198eY\u0016\u0014\bf\u0001\u0005\u0002\bA!\u0011\u0011BA\t\u001b\t\tYAC\u0002\u001e\u0003\u001bQ1!a\u0004%\u0003\u001d\u0019wN\u001c;fqRLA!a\u0005\u0002\f\t!!)Z1o\u0003Y\u0011XmZ5ti\u0016\u00148\u000b^8na\u0016sG\r]8j]R\u001cHcA4\u0002\u001a!1a.\u0003a\u0001\u00037\u00012aGA\u000f\u0013\r\ty\u0002\b\u0002\u0016'R|W\u000e]#oIB|\u0017N\u001c;SK\u001eL7\u000f\u001e:z\u0003i\u0019wN\u001c4jOV\u0014X-T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:t)\u0011\t)#a\u000b\u0011\u0007!\f9#C\u0002\u0002*%\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002.)\u0001\r!a\f\u0002#5,7o]1hK\u000e{gN^3si\u0016\u00148\u000f\u0005\u0004\u00022\u0005]\u00121H\u0007\u0003\u0003gQ1!!\u000ea\u0003\u0011)H/\u001b7\n\t\u0005e\u00121\u0007\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005^\u0001\nG>tg/\u001a:uKJLA!!\u0012\u0002@\t\u0001R*Z:tC\u001e,7i\u001c8wKJ$XM\u001d\u0015\u0004\u0001\u0005%\u0003cA\u000e\u0002L%\u0019\u0011Q\n\u000f\u00039\u0015s\u0017M\u00197f/\u0016\u00147k\\2lKRlUm]:bO\u0016\u0014%o\\6fe\"\u001a\u0001!!\u0015\u0011\t\u0005%\u00111K\u0005\u0005\u0003+\nYAA\u0007D_:4\u0017nZ;sCRLwN\u001c")
public class WebSocketMessageBrokerConfig
extends AbstractWebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter;
    @Autowired
    private final CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    private final String MESSAGE_BROKER_CONFIG_PREFIX;

    private String MESSAGE_BROKER_CONFIG_PREFIX() {
        return this.MESSAGE_BROKER_CONFIG_PREFIX;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(XldSystemConfig$.MODULE$.getSystemConfig().getInt(new StringBuilder(17).append(this.MESSAGE_BROKER_CONFIG_PREFIX()).append("input-buffer-size").toString()));
        long idleTimeout = TimeUnit.MINUTES.toMillis(ServerConfiguration.getInstance().getClientSessionTimeoutMinutes());
        policy.setIdleTimeout(idleTimeout);
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy(policy));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOrigins(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiMessageConverter(this.ciJsonMessageBodyReaderWriter));
        messageConverters.add((MessageConverter)new CisMessageConverter(this.cisJsonMessageBodyReaderWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter, @Autowired CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler) {
        this.ciJsonMessageBodyReaderWriter = ciJsonMessageBodyReaderWriter;
        this.cisJsonMessageBodyReaderWriter = cisJsonMessageBodyReaderWriter;
        this.taskScheduler = taskScheduler;
        this.MESSAGE_BROKER_CONFIG_PREFIX = "xl.deploy.websockets.message-broker.";
    }
}

