/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public final class DeploymentWriter {
    private DeploymentWriter() {
    }

    static Deployment createDeployment(DeployedApplication deployedApplication, Deployment.DeploymentType type) {
        Deployment deployment = new Deployment();
        deployment.setId("deployment-" + UUID.randomUUID().toString());
        deployment.setDeploymentType(type);
        deployment.setDeployedApplication((ConfigurationItem)deployedApplication);
        ArrayList requiredDeployments = new ArrayList();
        deployment.setGroupedRequiredDeployments(requiredDeployments);
        ArrayList<ConfigurationItemId> deployedApplicationDeployables = new ArrayList<ConfigurationItemId>(deployedApplication.getVersion().getDeployables().stream().map(DtoReader.ciToCiId::apply).collect(Collectors.toList()));
        deployment.setDeployables(DeploymentWriter.sort(deployedApplicationDeployables));
        deployment.setContainers(DeploymentWriter.sort(new ArrayList<ConfigurationItemId>(deployedApplication.getEnvironment().getMembers().stream().map(DtoReader.ciToCiId::apply).collect(Collectors.toList()))));
        return deployment;
    }

    private static List<ConfigurationItemId> sort(List<ConfigurationItemId> toBeSorted) {
        toBeSorted.sort(Comparator.comparing(ConfigurationItemId::getId));
        return toBeSorted;
    }

    static List<ConfigurationItem> convertDeployeds(List<Deployed> initialDeployeds) {
        ArrayList<ConfigurationItem> deployeds = new ArrayList<ConfigurationItem>();
        deployeds.addAll(initialDeployeds);
        for (ConfigurationItem configurationItem : initialDeployeds) {
            DeploymentWriter.addEmbeddeds(configurationItem, deployeds);
        }
        return deployeds;
    }

    private static void addEmbeddeds(ConfigurationItem deployed, List<ConfigurationItem> collector) {
        List propertyDescriptors = deployed.getType().getDescriptor().getPropertyDescriptors().stream().filter(DeploymentWriter::isEmbeddedDeployedProperty).collect(Collectors.toList());
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Collection c = (Collection)propertyDescriptor.get(deployed);
            for (ConfigurationItem configurationItem : c) {
                DeploymentWriter.addEmbeddeds(configurationItem, collector);
            }
            collector.addAll(c);
        }
    }

    private static boolean isEmbeddedDeployedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }
}

