/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.defaults.CiDefaultEntityPropertiesProcessor;
import com.xebialabs.deployit.core.ordering.ConfigurationItemIdComparator;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport;
import com.xebialabs.deployit.core.rest.util.RepositoryHelper;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemProperties;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.externalproperties.validation.ExternalPropertiesValidatorChain;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeployitRepositoryResource
extends RepositoryResource {
    @Context
    HttpResponse httpResponse;
    private final ConfigurationItemIdComparator comparator;
    private final RepositoryService repositoryService;

    @Autowired
    public DeployitRepositoryResource(RepositoryService repositoryService, Validator validator, ConfigurationItemIdComparator comparator, SourceArtifactScanner scanner, RepositoryHelper repositoryHelper, CiDefaultEntityPropertiesProcessor ciDefaultEntityPropertiesProcessor, ExternalPropertiesValidatorChain externalPropertiesValidatorChain) {
        super(repositoryService, validator, scanner, repositoryHelper, ciDefaultEntityPropertiesProcessor, externalPropertiesValidatorChain);
        this.comparator = comparator;
        this.repositoryService = repositoryService;
    }

    protected void checkDeletePermission(String id) {
        if (DeployitPermissions.IMPORT_REMOVE.isApplicableTo(id)) {
            this.checkPermission(DeployitPermissions.IMPORT_REMOVE, id);
        } else {
            this.checkPermission(PlatformPermissions.EDIT_REPO, id);
        }
    }

    public List<ConfigurationItemId> queryV2(Type type, String parent, String ancestor, String namePattern, String idPattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        List result = super.queryV2(type, parent, ancestor, namePattern, idPattern, lastModifiedBefore, lastModifiedAfter, page, resultPerPage);
        if (this.isNoPagination(resultPerPage)) {
            this.sort(result);
        }
        return result;
    }

    public List<ConfigurationItemId> queryV3(Type type, String parent, String ancestor, String namePattern, String idPattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage, ConfigurationItemProperties properties) {
        List result = super.queryV3(type, parent, ancestor, namePattern, idPattern, lastModifiedBefore, lastModifiedAfter, page, resultPerPage, properties);
        if (this.isNoPagination(resultPerPage)) {
            this.sort(result);
        }
        long totalCount = this.queryCount(type, parent, ancestor, namePattern);
        PaginationSupport.addTotalCountHeader((long)totalCount, (HttpResponse)this.httpResponse);
        return result;
    }

    private long queryCount(Type type, String parent, String ancestor, String namePattern) {
        SearchParameters searchParams = new SearchParameters();
        searchParams.setType(type).setParent(parent).setAncestor(ancestor).setName(namePattern);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(searchParams);
        return this.repositoryService.count(searchParams);
    }

    private void sort(List<ConfigurationItemId> result) {
        Collections.sort(result, this.comparator);
    }

    private boolean isNoPagination(long resultPerPage) {
        return resultPerPage <= 0L;
    }
}

