/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.typesafe.config.Config;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.rest.converters.CiMessageConverter;
import com.xebialabs.deployit.core.rest.converters.CisMessageConverter;
import com.xebialabs.deployit.core.rest.json.CiJsonMessageBodyReaderWriter;
import com.xebialabs.deployit.core.rest.json.CisJsonMessageBodyReaderWriter;
import com.xebialabs.xlplatform.config.ConfigLoader$;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import scala.reflect.ScalaSignature;

@Configuration
@EnableWebSocketMessageBroker
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0007\u000f\u0001mA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A!\n\u0001B\u0001B\u0003%1\nC\u0003Z\u0001\u0011\u0005!\fC\u0004e\u0001\t\u0007I\u0011B3\t\r%\u0004\u0001\u0015!\u0003g\u0011\u001dQ\u0007A1A\u0005\n-Daa\u001d\u0001!\u0002\u0013a\u0007\"\u0002;\u0001\t\u0003*\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003g\u0001A\u0011IA\u001b\u0011\u001d\ty\u0004\u0001C!\u0003\u0003\u0012AdV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3Ce>\\WM]\"p]\u001aLwM\u0003\u0002\u0010!\u0005Qq/\u001a2t_\u000e\\W\r^:\u000b\u0005E\u0011\u0012\u0001\u0002:fgRT!a\u0005\u000b\u0002\t\r|'/\u001a\u0006\u0003+Y\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003/a\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003e\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000f%!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003mC:<'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011aa\u00142kK\u000e$\bCA\u00133\u001b\u00051#BA\u0014)\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003S)\naaY8oM&<'BA\u0016-\u0003\u0019\u0019xnY6fi*\u0011QFL\u0001\u0004o\u0016\u0014'BA\u00181\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u0019\u0002\u0007=\u0014x-\u0003\u00024M\t\u0001s+\u001a2T_\u000e\\W\r^'fgN\fw-\u001a\"s_.,'oQ8oM&<WO]3s\u0003u\u0019\u0017NS:p]6+7o]1hK\n{G-\u001f*fC\u0012,'o\u0016:ji\u0016\u0014\bC\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0011\u0003\u0011Q7o\u001c8\n\u0005i:$!H\"j\u0015N|g.T3tg\u0006<WMQ8esJ+\u0017\rZ3s/JLG/\u001a:)\u0005\u0005a\u0004CA\u001fD\u001b\u0005q$BA\u0014@\u0015\t\u0001\u0015)A\u0004gC\u000e$xN]=\u000b\u0005\ts\u0013!\u00022fC:\u001c\u0018B\u0001#?\u0005%\tU\u000f^8xSJ,G-\u0001\u0010dSNT5o\u001c8NKN\u001c\u0018mZ3C_\u0012L(+Z1eKJ<&/\u001b;feB\u0011agR\u0005\u0003\u0011^\u0012adQ5t\u0015N|g.T3tg\u0006<WMQ8esJ+\u0017\rZ3s/JLG/\u001a:)\u0005\ta\u0014!\u0004;bg.\u001c6\r[3ek2,'\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002O]\u0005Q1o\u00195fIVd\u0017N\\4\n\u0005Ak%!\u0004+bg.\u001c6\r[3ek2,'\u000f\u000b\u0003\u0004%V3\u0006CA\u001fT\u0013\t!fHA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\nq+A\nxK\n\u001cxnY6fiN\u001c6\r[3ek2,'\u000f\u000b\u0002\u0004y\u00051A(\u001b8jiz\"BaW/`CB\u0011A\fA\u0007\u0002\u001d!)A\u0007\u0002a\u0001k!\u0012Q\f\u0010\u0005\u0006\u000b\u0012\u0001\rA\u0012\u0015\u0003?rBQA\u0013\u0003A\u0002-CC!\u0019*V-\"\u0012\u0011\rP\u0001\u001d\u001b\u0016\u001b6+Q$F?\n\u0013vjS#S?\u000e{eJR%H?B\u0013VIR%Y+\u00051\u0007CA\u000fh\u0013\tAgD\u0001\u0004TiJLgnZ\u0001\u001e\u001b\u0016\u001b6+Q$F?\n\u0013vjS#S?\u000e{eJR%H?B\u0013VIR%YA\u0005a1/_:uK6\u001cuN\u001c4jOV\tA\u000e\u0005\u0002nc6\taN\u0003\u0002*_*\u0011\u0001\u000fG\u0001\tif\u0004Xm]1gK&\u0011!O\u001c\u0002\u0007\u0007>tg-[4\u0002\u001bML8\u000f^3n\u0007>tg-[4!\u0003Y\u0019wN\u001c4jOV\u0014X-T3tg\u0006<WM\u0011:pW\u0016\u0014HC\u0001<}!\t9(0D\u0001y\u0015\u0005I\u0018!B:dC2\f\u0017BA>y\u0005\u0011)f.\u001b;\t\u000buL\u0001\u0019\u0001@\u0002\u0011I,w-[:uef\u00042a`A\u0006\u001b\t\t\tAC\u0002*\u0003\u0007QA!!\u0002\u0002\b\u0005!1/[7q\u0015\r\tIAL\u0001\n[\u0016\u001c8/Y4j]\u001eLA!!\u0004\u0002\u0002\t)R*Z:tC\u001e,'I]8lKJ\u0014VmZ5tiJL\u0018\u0001\u00055b]\u0012\u001c\b.Y6f\u0011\u0006tG\r\\3s)\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u000fM,\b\u000f]8si*\u0019\u0011Q\u0004\u0016\u0002\rM,'O^3s\u0013\u0011\t\t#a\u0006\u0003/\u0011+g-Y;mi\"\u000bg\u000eZ:iC.,\u0007*\u00198eY\u0016\u0014\bf\u0001\u0006\u0002&A!\u0011qEA\u0018\u001b\t\tICC\u0002(\u0003WQ1!!\f/\u0003\u001d\u0019wN\u001c;fqRLA!!\r\u0002*\t!!)Z1o\u0003Y\u0011XmZ5ti\u0016\u00148\u000b^8na\u0016sG\r]8j]R\u001cHc\u0001<\u00028!1Qp\u0003a\u0001\u0003s\u00012!JA\u001e\u0013\r\tiD\n\u0002\u0016'R|W\u000e]#oIB|\u0017N\u001c;SK\u001eL7\u000f\u001e:z\u0003i\u0019wN\u001c4jOV\u0014X-T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:t)\u0011\t\u0019%!\u0013\u0011\u0007]\f)%C\u0002\u0002Ha\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002L1\u0001\r!!\u0014\u0002#5,7o]1hK\u000e{gN^3si\u0016\u00148\u000f\u0005\u0004\u0002P\u0005U\u0013\u0011L\u0007\u0003\u0003#R1!a\u0015!\u0003\u0011)H/\u001b7\n\t\u0005]\u0013\u0011\u000b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\u0011\ty&a\u0002\u0002\u0013\r|gN^3si\u0016\u0014\u0018\u0002BA2\u0003;\u0012\u0001#T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:)\u0007\u0001\t9\u0007E\u0002&\u0003SJ1!a\u001b'\u0005q)e.\u00192mK^+'mU8dW\u0016$X*Z:tC\u001e,'I]8lKJD3\u0001AA8!\u0011\t9#!\u001d\n\t\u0005M\u0014\u0011\u0006\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public class WebSocketMessageBrokerConfig
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private final CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter;
    @Autowired
    private final CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter;
    @Autowired
    @Qualifier(value="websocketsScheduler")
    private final TaskScheduler taskScheduler;
    private final String MESSAGE_BROKER_CONFIG_PREFIX;
    private final Config systemConfig;

    public void configureWebSocketTransport(WebSocketTransportRegistration x$1) {
        super.configureWebSocketTransport(x$1);
    }

    public void configureClientInboundChannel(ChannelRegistration x$1) {
        super.configureClientInboundChannel(x$1);
    }

    public void configureClientOutboundChannel(ChannelRegistration x$1) {
        super.configureClientOutboundChannel(x$1);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> x$1) {
        super.addArgumentResolvers(x$1);
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> x$1) {
        super.addReturnValueHandlers(x$1);
    }

    private String MESSAGE_BROKER_CONFIG_PREFIX() {
        return this.MESSAGE_BROKER_CONFIG_PREFIX;
    }

    private Config systemConfig() {
        return this.systemConfig;
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.enableSimpleBroker(new String[]{"/topic"}).setTaskScheduler(this.taskScheduler);
    }

    @Bean
    public DefaultHandshakeHandler handshakeHandler() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(this.systemConfig().getInt(new StringBuilder(17).append(this.MESSAGE_BROKER_CONFIG_PREFIX()).append("input-buffer-size").toString()));
        long idleTimeout = TimeUnit.MINUTES.toMillis(ServerConfiguration.getInstance().getClientSessionTimeoutMinutes());
        policy.setIdleTimeout(idleTimeout);
        return new DefaultHandshakeHandler((RequestUpgradeStrategy)new JettyRequestUpgradeStrategy(policy));
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/ws"}).setAllowedOrigins(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.handshakeHandler()).withSockJS();
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        messageConverters.add((MessageConverter)new CiMessageConverter(this.ciJsonMessageBodyReaderWriter));
        messageConverters.add((MessageConverter)new CisMessageConverter(this.cisJsonMessageBodyReaderWriter));
        return true;
    }

    public WebSocketMessageBrokerConfig(@Autowired CiJsonMessageBodyReaderWriter ciJsonMessageBodyReaderWriter, @Autowired CisJsonMessageBodyReaderWriter cisJsonMessageBodyReaderWriter, @Autowired @Qualifier(value="websocketsScheduler") TaskScheduler taskScheduler) {
        this.ciJsonMessageBodyReaderWriter = ciJsonMessageBodyReaderWriter;
        this.cisJsonMessageBodyReaderWriter = cisJsonMessageBodyReaderWriter;
        this.taskScheduler = taskScheduler;
        this.MESSAGE_BROKER_CONFIG_PREFIX = "xl.deploy.websockets.message-broker.";
        this.systemConfig = ConfigLoader$.MODULE$.loadWithDynamic("xl-deploy.conf");
    }
}

