/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Strings;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractTaskRestrictedResource
extends AbstractSecuredResource {
    @Autowired
    protected TaskArchive taskArchive;
    @Autowired
    protected PaginationService paginationService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ReportGenerator reportGenerator;

    protected void checkAccessTo(Map<String, String> taskMetadata) {
        boolean isCloudTask;
        if (PermissionHelper.isCurrentUserAdmin()) {
            return;
        }
        boolean isControlTask = TaskType.CONTROL.name().equals(taskMetadata.get("taskType"));
        boolean bl = isCloudTask = taskMetadata.get("cloudOperation") != null;
        if (isCloudTask) {
            this.doCloudTaskPermissionCheck(taskMetadata);
        } else if (isControlTask) {
            this.doControlTaskPermissionCheck(taskMetadata);
        } else {
            this.doDeploymentTaskPermissionCheck(taskMetadata);
        }
    }

    protected boolean hasTaskPermission(Map<String, String> taskMetadata) {
        boolean isCloudTask;
        boolean isControlTask = TaskType.CONTROL.name().equals(taskMetadata.get("taskType"));
        boolean bl = isCloudTask = taskMetadata.get("cloudOperation") != null;
        if (isCloudTask) {
            return this.hasCloudTaskPermission(taskMetadata);
        }
        if (isControlTask) {
            return this.hasTargetOrIsAdmin(taskMetadata) && this.hasControlTaskPermission(taskMetadata);
        }
        return this.hasDeploymentTaskPermission(taskMetadata, this.getApplicationId(taskMetadata));
    }

    private void doDeploymentTaskPermissionCheck(Map<String, String> taskMetadata) {
        String appId = this.getApplicationId(taskMetadata);
        if (appId == null) {
            throw new DeployitException("Unable to locate application for report");
        }
        if (!this.hasDeploymentTaskPermission(taskMetadata, appId)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and application to view the archived task.");
        }
    }

    private boolean hasDeploymentTaskPermission(Map<String, String> taskMetadata, String appId) {
        String environmentId = this.getEnvironmentId(taskMetadata);
        return appId != null && this.hasPermission(PlatformPermissions.READ, environmentId) && this.hasPermission(PlatformPermissions.READ, appId);
    }

    private String getApplicationId(Map<String, String> taskMetadata) {
        if (taskMetadata.containsKey("application_internal_id")) {
            Integer internalAppId = Integer.parseInt(taskMetadata.get("application_internal_id"));
            return this.getCiIdByInternalId(internalAppId, Application.class);
        }
        return this.getApplicationByName(taskMetadata.get("application"));
    }

    private String getEnvironmentId(Map<String, String> taskMetadata) {
        if (taskMetadata.containsKey("environment_internal_id")) {
            return this.getCiIdByInternalId(Integer.parseInt(taskMetadata.get("environment_internal_id")), Environment.class);
        }
        return taskMetadata.get("environment_id");
    }

    private String getApplicationByName(String name) {
        SearchParameters criteria = new SearchParameters().setType(Type.valueOf(Application.class)).setName(name);
        return this.searchCiIdByCriteria(criteria);
    }

    private String getCiIdByInternalId(Integer internalId, Class ciType) {
        SearchParameters criteria = new SearchParameters().setType(Type.valueOf((Class)ciType)).setInternalId(internalId);
        return this.searchCiIdByCriteria(criteria);
    }

    private String searchCiIdByCriteria(SearchParameters criteria) {
        List cis = this.repositoryService.list(criteria);
        return cis.size() != 1 ? null : ((ConfigurationItemData)cis.get(0)).getId();
    }

    private void doControlTaskPermissionCheck(Map<String, String> taskMetadata) {
        if (!this.hasTargetOrIsAdmin(taskMetadata)) {
            throw PermissionDeniedException.withMessage((String)"Control tasks that don't have their target CI archived can only be viewed by admin.");
        }
        if (!this.hasControlTaskPermission(taskMetadata)) {
            throw PermissionDeniedException.withMessage((String)"You need controltask#execute permission on an archived control task's target CI to view it.");
        }
    }

    private boolean hasTargetOrIsAdmin(Map<String, String> taskMetadata) {
        return !Strings.isNullOrEmpty((String)taskMetadata.get("controlTaskTargetCI")) || PermissionHelper.isCurrentUserAdmin();
    }

    private boolean hasControlTaskPermission(Map<String, String> taskMetadata) {
        return this.hasPermission(DeployitPermissions.CONTROLTASK_EXECUTE, taskMetadata.get("controlTaskTargetCI"));
    }

    private boolean hasCloudTaskPermission(Map<String, String> taskMetadata) {
        String cloudEnvId = taskMetadata.get("cloudEnvironmentId");
        String cloudTemplId = taskMetadata.get("cloudEnvironmentTemplateId");
        return this.hasPermission(PlatformPermissions.READ, cloudEnvId) && this.hasPermission(PlatformPermissions.READ, cloudTemplId);
    }

    private void doCloudTaskPermissionCheck(Map<String, String> taskMetadata) {
        if (!this.hasCloudTaskPermission(taskMetadata)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and the environment template to view the archived cloud task.");
        }
    }

    public void setPaginationService(PaginationService paginationService) {
        this.paginationService = paginationService;
    }

    public void setReportGenerator(ReportGenerator reportGenerator) {
        this.reportGenerator = reportGenerator;
    }
}

