/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.xebialabs.deployit.core.rest.json.ReaderPostProcessor;
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CiJsonMessageBodyReaderWriter
implements MessageBodyWriter<ConfigurationItem>,
MessageBodyReader<ConfigurationItem> {
    private final ReaderPostProcessor postProcessor;

    @Autowired
    public CiJsonMessageBodyReaderWriter(ReaderPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(type, genericType, annotations, mediaType);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.toString().contains("application/json") && ConfigurationItem.class.isAssignableFrom(type);
    }

    public long getSize(ConfigurationItem t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ConfigurationItem ci, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        PasswordEncryptingCiConverter converter = this.getConverter();
        CiJsonWriter writer = new CiJsonWriter();
        converter.writeCi(ci, (CiWriter)writer);
        entityStream.write(writer.toString().getBytes());
    }

    public ConfigurationItem readFrom(Class<ConfigurationItem> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        boolean skipNotExistingCis = "true".equals(httpHeaders.getFirst((Object)"skipNotExistingCis"));
        return this.postProcessor.apply(context -> {
            PasswordEncryptingCiConverter converter = this.getConverter();
            context.register((ConfigurationItemConverter)converter);
            return converter.readCi((CiReader)CiJsonReader.create((String)CiJsonMessageBodyReaderWriter.toString(entityStream)));
        }, skipNotExistingCis);
    }

    private PasswordEncryptingCiConverter getConverter() {
        return new PasswordEncryptingCiConverter();
    }

    public static String toString(InputStream in) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(in, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

