/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.websockets;

import com.xebialabs.deployit.core.events.ChangeSetEvent;
import com.xebialabs.deployit.core.websockets.WebSocketEndpoints;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import java.util.Collection;
import nl.javadude.t2bus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.Serializable;
import scala.collection.convert.ImplicitConversions$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0005\u000b\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006m\u0001!\ta\u000e\u0005\u0006y\u0001!I!\u0010\u0005\u0006W\u0002!\t\u0001\u001c\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u00028\u0001!\t!!\u000f\u0003/]+'mU8dW\u0016$X*Z:tC\u001e,7oU3oI\u0016\u0014(BA\u0006\r\u0003)9XMY:pG.,Go\u001d\u0006\u0003\u001b9\tAA]3ti*\u0011q\u0002E\u0001\u0005G>\u0014XM\u0003\u0002\u0012%\u0005AA-\u001a9m_fLGO\u0003\u0002\u0014)\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002+\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u001f5,7o]1hKR+W\u000e\u001d7bi\u0016\u0004\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\tMLW\u000e\u001d\u0006\u0003I\u0015\n\u0011\"\\3tg\u0006<\u0017N\\4\u000b\u0005\u0019:\u0013aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003!\n1a\u001c:h\u0013\tQ\u0013EA\u000bTS6\u0004X*Z:tC\u001eLgn\u001a+f[Bd\u0017\r^3)\u0005\u0005a\u0003CA\u00175\u001b\u0005q#BA\u00181\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003cI\nqAZ1di>\u0014\u0018P\u0003\u00024K\u0005)!-Z1og&\u0011QG\f\u0002\n\u0003V$xn^5sK\u0012\fa\u0001P5oSRtDC\u0001\u001d;!\tI\u0004!D\u0001\u000b\u0011\u0015q\"\u00011\u0001 Q\tQD&\u0001\to_RLg-_%g\u001d>$X)\u001c9usR!a(\u0011%_!\tIr(\u0003\u0002A5\t!QK\\5u\u0011\u0015\u00115\u00011\u0001D\u0003!)g\u000e\u001a9pS:$\bC\u0001#G\u001b\u0005)%BA\u0006\u000f\u0013\t9UI\u0001\nXK\n\u001cvnY6fi\u0016sG\r]8j]R\u001c\b\"B%\u0004\u0001\u0004Q\u0015aA2jgB\u00121*\u0016\t\u0004\u0019F\u001bV\"A'\u000b\u00059{\u0015\u0001B;uS2T\u0011\u0001U\u0001\u0005U\u00064\u0018-\u0003\u0002S\u001b\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0005Q+F\u0002\u0001\u0003\n-\"\u000b\t\u0011!A\u0003\u0002]\u00131a\u0018\u00132#\tA6\f\u0005\u0002\u001a3&\u0011!L\u0007\u0002\b\u001d>$\b.\u001b8h!\tIB,\u0003\u0002^5\t\u0019\u0011I\\=\t\u000b}\u001b\u0001\u0019\u00011\u0002\u0011U\u001cXM\u001d8b[\u0016\u0004\"!\u00195\u000f\u0005\t4\u0007CA2\u001b\u001b\u0005!'BA3\u0017\u0003\u0019a$o\\8u}%\u0011qMG\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002h5\u000592/\u001a8e\u0007&\u001c\u0005.\u00198hKN+G/T3tg\u0006<Wm\u001d\u000b\u0003}5DQA\u001c\u0003A\u0002=\fQ!\u001a<f]R\u0004\"\u0001]:\u000e\u0003ET!A\u001d\b\u0002\r\u00154XM\u001c;t\u0013\t!\u0018O\u0001\bDQ\u0006tw-Z*fi\u00163XM\u001c;)\u0005\u00111\bCA<\u007f\u001b\u0005A(BA={\u0003\u0015!(GY;t\u0015\tYH0\u0001\u0005kCZ\fG-\u001e3f\u0015\u0005i\u0018A\u00018m\u0013\ty\bPA\u0005Tk\n\u001c8M]5cK\u0006\u0001cn\u001c;jMf\f%m\\;u\u001b\u0006Lg\u000e^3oC:\u001cW-T8eK\u000eC\u0017M\\4f)\rq\u0014Q\u0001\u0005\b\u0003\u000f)\u0001\u0019AA\u0005\u0003\u001d)g.\u00192mK\u0012\u00042!GA\u0006\u0013\r\tiA\u0007\u0002\b\u0005>|G.Z1o\u0003-9W\r^+tKJt\u0015-\\3\u0016\u0005\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eq*\u0001\u0003mC:<\u0017bA5\u0002\u0018\u000512/\u001a8e\u001b\u0006Lg\u000e^3oC:\u001cWm\u0015;beR,G\rF\u0002?\u0003CAaA\\\u0004A\u0002\u0005\r\u0002\u0003BA\u0013\u0003ci!!a\n\u000b\u00079\fIC\u0003\u0003\u0002,\u00055\u0012aA:qS*\u0019\u0011q\u0006\t\u0002\r\u0015tw-\u001b8f\u0013\u0011\t\u0019$a\n\u0003+5\u000b\u0017N\u001c;f]\u0006t7-Z*uCJ$XI^3oi\"\u0012qA^\u0001\u0017g\u0016tG-T1j]R,g.\u00198dKN#x\u000e\u001d9fIR\u0019a(a\u000f\t\r9D\u0001\u0019AA\u001f!\u0011\t)#a\u0010\n\t\u0005\u0005\u0013q\u0005\u0002\u0015\u001b\u0006Lg\u000e^3oC:\u001cWm\u0015;pa\u00163XM\u001c;)\u0005!1\bf\u0001\u0001\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\u0015\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\t&a\u0013\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class WebSocketMessagesSender {
    @Autowired
    private final SimpMessagingTemplate messageTemplate;

    private void notifyIfNotEmpty(WebSocketEndpoints endpoint, Collection<?> cis, String username) {
        block0: {
            if (!ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(cis).nonEmpty()) break block0;
            this.messageTemplate.convertAndSendToUser(username, endpoint.getName(), cis);
        }
    }

    @Subscribe
    public void sendCiChangeSetMessages(ChangeSetEvent event) {
        String username = (String)event.username().getOrElse((Function0 & java.io.Serializable & Serializable)() -> this.getUserName());
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_CREATE, event.createCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_UPDATE, event.updateCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_DELETE, event.deleteCiIds(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_RENAME, event.renameCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_MOVE, event.moveCis(), username);
        this.notifyIfNotEmpty(WebSocketEndpoints.TOPIC_CI_COPY, event.copyCis(), username);
    }

    private void notifyAboutMaintenanceModeChange(boolean enabled) {
        this.messageTemplate.convertAndSend((Object)WebSocketEndpoints.TOPIC_MAINTENANCE.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)enabled));
    }

    private String getUserName() {
        return SecurityContextHolder.getContext().getAuthentication().getName();
    }

    @Subscribe
    public void sendMaintenanceStarted(MaintenanceStartEvent event) {
        this.notifyAboutMaintenanceModeChange(true);
    }

    @Subscribe
    public void sendMaintenanceStopped(MaintenanceStopEvent event) {
        this.notifyAboutMaintenanceModeChange(false);
    }

    public WebSocketMessagesSender(@Autowired SimpMessagingTemplate messageTemplate) {
        this.messageTemplate = messageTemplate;
        EventBusHolder.register((Object)this);
    }
}

