/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtils {
    private static final Logger log = LoggerFactory.getLogger(ReportUtils.class);
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");
    static final PeriodFormatter HH_MM_SS = new PeriodFormatterBuilder().minimumPrintedDigits(2).printZeroAlways().appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().toFormatter();
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Joiner FIELD_JOINER = Joiner.on((String)",");
    private static final Function<Object, String> QUOTE = input -> String.format("\"%s\"", input);

    private ReportUtils() {
    }

    static final String formatToHoursMinsSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return HH_MM_SS.print((ReadablePeriod)period);
    }

    public static Stream<String> toCsv(Stream<ReportLine> report) {
        return report.map(new HeadersFirstLine());
    }

    private static String line(Iterable<?> fields) {
        return FIELD_JOINER.join((Iterable)FluentIterable.from(fields).transform(QUOTE));
    }

    private static TreeMap<String, Object> sorted(ReportLine line) {
        return new TreeMap<String, Object>(line.getValues());
    }

    public static List<DateTime> getMonthsOfInterval(DateTime begin, DateTime end) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        DateTime current = begin;
        while (current.isBefore((ReadableInstant)end) || current.isEqual((ReadableInstant)begin)) {
            result.add(current);
            current = current.plusMonths(1);
        }
        return result;
    }

    public static String createDownloadToken(DownloadResource downloadResource, Stream<ReportLine> reportLines, String fileName) {
        try {
            File to = new File(WorkdirHolder.get().getPath(), fileName);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(to), Charset.defaultCharset()));
                 Stream<String> s = ReportUtils.toCsv(reportLines);){
                s.forEachOrdered(line -> {
                    try {
                        writer.write((String)line);
                        writer.write(10);
                    }
                    catch (IOException io) {
                        throw new RuntimeException(io);
                    }
                });
            }
            return downloadResource.register(to, "text/csv");
        }
        catch (Exception re) {
            log.error("Oops!", (Throwable)re);
            WorkdirHolder.get().delete();
            throw new IllegalStateException(re);
        }
    }

    public static String createDownloadToken(DownloadResource downloadResource, Report report, String fileName) {
        return ReportUtils.createDownloadToken(downloadResource, report.getLines().stream(), fileName);
    }

    private static class HeadersFirstLine
    implements java.util.function.Function<ReportLine, String> {
        boolean first = true;

        private HeadersFirstLine() {
        }

        @Override
        public String apply(ReportLine reportLine) {
            TreeMap sorted = ReportUtils.sorted(reportLine);
            if (this.first) {
                this.first = false;
                return LINE_JOINER.join((Object)ReportUtils.line(sorted.keySet()), (Object)ReportUtils.line(sorted.values()), new Object[0]);
            }
            return ReportUtils.line(sorted.values());
        }
    }
}

