/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.AddressFromURIString$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.core.api.WorkersService;
import com.xebialabs.deployit.core.api.dto.WorkerInfo;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.rest.api.WorkerState$;
import com.xebialabs.deployit.core.rest.api.WorkersSorting$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.settings.CommonSettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\t\u0013\u0001}A\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001dI\bA1A\u0005\fiDq!a\u0001\u0001A\u0003%1\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011Q\u0004\u0001!\u0002\u0013\tI\u0001C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBAI\u0001\u0011%\u00111\u0013\u0005\b\u0003?\u0003A\u0011IAQ\u0011\u001d\t)\u000b\u0001C!\u0003OCq!!+\u0001\t\u0003\nYKA\bX_J\\WM]:SKN|WO]2f\u0015\t\u0019B#A\u0002ba&T!!\u0006\f\u0002\tI,7\u000f\u001e\u0006\u0003/a\tAaY8sK*\u0011\u0011DG\u0001\tI\u0016\u0004Hn\\=ji*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0005\u0001\u000123\u0006\u0005\u0002\"I5\t!E\u0003\u0002$)\u000591/Z2ve\u0016$\u0017BA\u0013#\u0005]\t%m\u001d;sC\u000e$8+Z2ve\u0016$'+Z:pkJ\u001cW\r\u0005\u0002(S5\t\u0001F\u0003\u0002\u0014-%\u0011!\u0006\u000b\u0002\u000f/>\u00148.\u001a:t'\u0016\u0014h/[2f!\ta\u0013'D\u0001.\u0015\tqs&A\u0003tY\u001a$$NC\u00011\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001a.\u0005\u001daunZ4j]\u001e\fQb^8sW\u0016\u0014X*\u00198bO\u0016\u0014\bCA\u001b;\u001b\u00051$BA\u001c9\u0003\u0015\t7\r^8s\u0015\u0005I\u0014\u0001B1lW\u0006L!a\u000f\u001c\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDC!A\u001fL\u0019B\u0011a(S\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u000bC:tw\u000e^1uS>t'B\u0001\"D\u0003\u001d1\u0017m\u0019;pefT!\u0001R#\u0002\u000b\t,\u0017M\\:\u000b\u0005\u0019;\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003!\u000b1a\u001c:h\u0013\tQuHA\u0005Rk\u0006d\u0017NZ5fe\u0006)a/\u00197vK\u0006\n1\u0007\u000b\u0002\u0002\u001dB\u0011ahT\u0005\u0003!~\u0012\u0011\"Q;u_^L'/\u001a3\u0002!]|'o[3s%\u0016\u0004xn]5u_JL\bCA*Z\u001b\u0005!&BA+W\u00031!\u0017n\u001d;sS\n,H/[8o\u0015\t\u0019rK\u0003\u0002Y1\u00051QM\\4j]\u0016L!A\u0017+\u0003;Q\u000b7o[#yK\u000e,H/[8o/>\u00148.\u001a:SKB|7/\u001b;pefD#A\u0001(\u0002'Q\f7o[#yK\u000e,H/[8o\u000b:<\u0017N\\3\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001<\u0016A\u0002;bg.,'/\u0003\u0002c?\n\u0019B+Y:l\u000bb,7-\u001e;j_:,enZ5oK\"\u00121AT\u0001\nq2$7i\u001c8gS\u001e\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\f\u0002\r\r|gNZ5h\u0013\tQwMA\u0005YY\u0012\u001cuN\u001c4jO\"\u0012AAT\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9\u00048/^<\u0011\u0005=\u0004Q\"\u0001\n\t\u000bM*\u0001\u0019\u0001\u001b)\tAl4\n\u0014\u0015\u0003a:CQ!U\u0003A\u0002IC#a\u001d(\t\u000bq+\u0001\u0019A/)\u0005Ut\u0005\"\u00023\u0006\u0001\u0004)\u0007FA<O\u0003\u001d!\u0018.\\3pkR,\u0012a\u001f\t\u0003y~l\u0011! \u0006\u0003}b\nA!\u001e;jY&\u0019\u0011\u0011A?\u0003\u000fQKW.Z8vi\u0006AA/[7f_V$\b%\u0001\u0007iiR\u0004(+Z:q_:\u001cX-\u0006\u0002\u0002\nA!\u00111BA\r\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011aA:qS*!\u00111CA\u000b\u0003!\u0011Xm\u001d;fCNL(bAA\f\u000f\u0006)!NY8tg&!\u00111DA\u0007\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u00035AG\u000f\u001e9SKN\u0004xN\\:fA!\u001a\u0011\"!\t\u0011\t\u0005\r\u00121G\u0007\u0003\u0003KQ1aFA\u0014\u0015\u0011\tI#a\u000b\u0002\u0005I\u001c(\u0002BA\u0017\u0003_\t!a^:\u000b\u0005\u0005E\u0012!\u00026bm\u0006D\u0018\u0002BA\u001b\u0003K\u0011qaQ8oi\u0016DH/A\btQV$Hm\\<o/>\u00148.\u001a:t)\u0011\tY$a\u0012\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ!!!\u0011\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u0015\u0013q\b\u0002\u0005+:LG\u000fC\u0004\u0002J)\u0001\r!a\u0013\u0002\u000f]|'o[3sgB1\u0011QJA+\u00033j!!a\u0014\u000b\u0007y\f\tF\u0003\u0002\u0002T\u0005!!.\u0019<b\u0013\u0011\t9&a\u0014\u0003\t1K7\u000f\u001e\t\u0005\u00037\nIG\u0004\u0003\u0002^\u0005\u0015\u0004\u0003BA0\u0003\u007fi!!!\u0019\u000b\u0007\u0005\rd$\u0001\u0004=e>|GOP\u0005\u0005\u0003O\ny$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\niG\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003O\ny$\u0001\btQV$Hm\\<o/>\u00148.\u001a:\u0015\t\u0005m\u00121\u000f\u0005\b\u0003kZ\u0001\u0019AA<\u0003!9xN]6fe&#\u0007\u0003BA=\u0003\u007fj!!a\u001f\u000b\t\u0005u\u0014\u0011K\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0002\u0006m$aB%oi\u0016<WM]\u0001\u000eSNdunY1m/>\u00148.\u001a:\u0015\t\u0005\u001d\u0015Q\u0012\t\u0005\u0003{\tI)\u0003\u0003\u0002\f\u0006}\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001fc\u0001\u0019AA-\u0003\u001d\tG\r\u001a:fgN\fQ\u0003\u001e5s_^dunY1m/>\u00148.\u001a:FeJ|'\u000f\u0006\u0003\u0002\u0016\u0006m\u0005\u0003BA\u001f\u0003/KA!!'\u0002@\t9aj\u001c;iS:<\u0007bBAO\u001b\u0001\u0007\u0011\u0011L\u0001\u0002g\u0006a!/Z7pm\u0016<vN]6feR!\u00111HAR\u0011\u001d\t)H\u0004a\u0001\u0003o\nAC]3sK\u001eL7\u000f^3s\u000f\"|7\u000f\u001e+bg.\u001cHCAA&\u0003-a\u0017n\u001d;X_J\\WM]:\u0015\r\u00055\u00161XAe!\u0019\ti%!\u0016\u00020B!\u0011\u0011WA\\\u001b\t\t\u0019LC\u0002\u00026\"\n1\u0001\u001a;p\u0013\u0011\tI,a-\u0003\u0015]{'o[3s\u0013:4w\u000eC\u0004\u0002>B\u0001\r!a0\u0002\rA\fw-\u001b8h!\u0011\t\t-!2\u000e\u0005\u0005\r'bAA[-&!\u0011qYAb\u0005\u0019\u0001\u0016mZ5oO\"9\u00111\u001a\tA\u0002\u00055\u0017!B8sI\u0016\u0014\b\u0003BAa\u0003\u001fLA!!5\u0002D\nAqJ\u001d3fe&tw\rK\u0002\u0001\u0003+\u0004B!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0004\u00037,\u0015AC:uKJ,w\u000e^=qK&!\u0011q\\Am\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class WorkersResource
extends AbstractSecuredResource
implements WorkersService,
Logging {
    @Autowired
    @Qualifier(value="workerManager")
    private final ActorRef workerManager;
    @Autowired
    private final TaskExecutionWorkerRepository workerRepository;
    @Autowired
    private final TaskExecutionEngine taskExecutionEngine;
    private final Timeout timeout;
    @Context
    private final HttpResponse httpResponse;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkersResource workersResource = this;
        synchronized (workersResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public void shutdownWorkers(java.util.List<String> workers) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (workers.isEmpty()) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Shutting down all workers.");
        } else {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Shutting down workers ").append(workers).append(".").toString());
        }
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(workers).find((Function1 & Serializable & scala.Serializable)address -> BoxesRunTime.boxToBoolean((boolean)this.isLocalWorker(address))).foreach((Function1 & Serializable & scala.Serializable)s -> this.throwLocalWorkerError((String)s));
        ((List)this.workerRepository.listWorkers().map((Function1 & Serializable & scala.Serializable)x$1 -> (Worker)x$1._1(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorkers$6(this, workers, worker);
            return BoxedUnit.UNIT;
        });
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.workerManager);
        WorkerManager.messages$.ShutdownWorker x$12 = new WorkerManager.messages$.ShutdownWorker(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workers).asScala()).toList(), true);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$12);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$12, x$2, x$3), (Duration)this.timeout().duration());
        if (!workers.isEmpty()) {
            List shutdownWorkers = response.workers();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.").toString());
            ArrayList<String> notFound = new ArrayList<String>(workers);
            notFound.removeAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)shutdownWorkers).asJava());
            if (!notFound.isEmpty()) {
                throw new NotFoundException(new StringBuilder(40).append("Workers ").append(ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(notFound).mkString("[", ", ", "]")).append(" not found. (Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.)").toString());
            }
        }
    }

    public void shutdownWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Worker for id ").append(workerId).append(" not found.").toString());
        }).foreach((Function1 & Serializable & scala.Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorker$2(this, worker);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isLocalWorker(String address) {
        return AddressFromURIString$.MODULE$.apply(address).hasLocalScope();
    }

    private Nothing$ throwLocalWorkerError(String s) {
        throw new IllegalArgumentException(new StringBuilder(35).append("Local worker (").append(s).append(") cannot be shutdown.").toString());
    }

    public void removeWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Worker for id ").append(workerId).append(" not found.").toString());
        }).foreach((Function1 & Serializable & scala.Serializable)worker -> {
            WorkersResource.$anonfun$removeWorker$2(this, workerId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<String> reregisterGhostTasks() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return this.taskExecutionEngine.reregisterGhostTasks();
    }

    public java.util.List<WorkerInfo> listWorkers(Paging paging, com.xebialabs.deployit.engine.api.dto.Ordering order) {
        java.util.List list;
        this.checkPermission(PlatformPermissions.ADMIN);
        Timeout timeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.workerManager);
        WorkerManager.messages$.FetchWorkers x$1 = new WorkerManager.messages$.FetchWorkers();
        Timeout x$22 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$22, x$3), (Duration)timeout.duration());
        List workers = (List)this.workerRepository.listWorkers().map(Function$.MODULE$.tupled((Function3 & Serializable & scala.Serializable)(w, deploymentTasks, controlTasks) -> new WorkerInfo(Predef$.MODULE$.Integer2int(w.id()), w.name(), w.address(), WorkersResource.calculateState$1(w, response.healthy(), response.incompatible(), response.draining()).toString(), Predef$.MODULE$.Integer2int(deploymentTasks), Predef$.MODULE$.Integer2int(controlTasks))), List$.MODULE$.canBuildFrom());
        if ((paging == null || paging.resultsPerPage() == -1) && order == null) {
            list = ((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)workers.sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()), (Ordering)Ordering.Int$.MODULE$)).asJava()).stream().collect(Collectors.toList());
        } else {
            PaginationSupport$.MODULE$.addTotalCountHeader((long)workers.size(), this.httpResponse());
            int from = (paging.page() - 1) * paging.resultsPerPage();
            int to = from + paging.resultsPerPage() <= ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)workers).size() ? from + paging.resultsPerPage() : ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)workers).size();
            list = ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)WorkersSorting$.MODULE$.sort((List<WorkerInfo>)workers, order).slice(from, to));
        }
        return list;
    }

    public static final /* synthetic */ void $anonfun$shutdownWorkers$6(WorkersResource $this, java.util.List workers$1, Worker worker) {
        block0: {
            if (!workers$1.isEmpty() && !workers$1.contains(worker.address())) break block0;
            $this.workerRepository.removeTasks(worker.id());
        }
    }

    public static final /* synthetic */ void $anonfun$shutdownWorker$2(WorkersResource $this, Worker worker) {
        String address = worker.address();
        if ($this.isLocalWorker(address)) {
            throw $this.throwLocalWorkerError(address);
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask($this.workerManager);
        WorkerManager.messages$.ShutdownWorker x$1 = new WorkerManager.messages$.ShutdownWorker((List)new .colon.colon((Object)address, (List)Nil$.MODULE$), false);
        Timeout x$2 = $this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)$this.timeout().duration());
        List shutdownWorkers = response.workers();
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Workers ").append(shutdownWorkers.mkString("[", ", ", "]")).append(" shutdown.").toString());
        if (!response.workers().contains((Object)address)) {
            throw new NotFoundException(new StringBuilder(18).append("Worker ").append(address).append(" not found.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$removeWorker$2(WorkersResource $this, Integer workerId$2, Worker worker) {
        ActorRef x$3;
        Timeout x$2;
        WorkerManager.messages$.FetchWorkers x$1;
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask($this.workerManager);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = new WorkerManager.messages$.FetchWorkers()), x$2 = $this.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)$this.timeout().duration());
        List active = (List)response.draining().$plus$plus((GenTraversableOnce)response.healthy(), List$.MODULE$.canBuildFrom());
        if (active.contains((Object)worker.address())) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Worker for id ").append(workerId$2).append(" is still active, cannot be removed.").toString());
        }
        $this.workerRepository.removeTasks(workerId$2);
        $this.workerRepository.removeWorker(workerId$2);
    }

    private static final Enumeration.Value calculateState$1(Worker w, List healthy, List incompatible, List draining) {
        return healthy.contains((Object)w.address()) ? WorkerState$.MODULE$.CONNECTED() : (incompatible.contains((Object)w.address()) ? WorkerState$.MODULE$.INCOMPATIBLE() : (draining.contains((Object)w.address()) ? WorkerState$.MODULE$.DRAINING() : WorkerState$.MODULE$.DISCONNECTED()));
    }

    public WorkersResource(@Autowired @Qualifier(value="workerManager") ActorRef workerManager, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired TaskExecutionEngine taskExecutionEngine, @Autowired XldConfig xldConfig) {
        this.workerManager = workerManager;
        this.workerRepository = workerRepository;
        this.taskExecutionEngine = taskExecutionEngine;
        Logging.$init$((Logging)this);
        this.timeout = new CommonSettings(xldConfig.rootConfig()).tasker().askTimeout();
        this.httpResponse = null;
    }
}

