package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.WorkerInfo;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Path("workers")
public interface WorkersService {

    /**
     * Forcefully shutdown workers by address, if no address provided all of workers will shutdown.
     */
    @DELETE
    void shutdownWorkers(@QueryParam("worker") List<String> workers);

    /**
     * Gracefully shutdown a worker by id.
     */
    @PUT
    @Path("{workerId}/shutdown")
    void shutdownWorker(@PathParam("workerId") Integer workerId);

    /**
     * Remove a disconnected worker (and possibly related tasks) from the system.
     */
    @DELETE
    @Path("{workerId}")
    void removeWorker(@PathParam("workerId") Integer workerId);

    /**
     * Lists all workers
     */
    @GET
    List<WorkerInfo> listWorkers(@BeanParam Paging paging, @QueryParam("order") Ordering order);

    /**
     * Find ghost tasks on a worker (tasks that are not registered in the system) and re-register them.
     *
     * @return The ghost tasks found and reregistered.
     */
    @PATCH
    @Path("tasks/reregister")
    List<String> reregisterGhostTasks();
}
