package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.BannerInfo;
import com.xebialabs.xlplatform.documentation.PublicApi;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

/**
 * Retrieves and modifies the banner shown in the XL Deploy GUI
 */
@Path("/banner")
@PublicApi
public interface BannerService {

    /**
     * Gets the banner to display
     *
     * @param kind - either MAINTENANCE or INFORMATION
     * @return the requested {@see com.xebialabs.deployit.core.api.dto.BannerInfo}
     */
    @GET
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    BannerInfo getBannerInfo(@QueryParam("kind") BannerInfo.BannerKind kind);

    /**
     * Admin only - Set the HTML contents for either MAINTENANCE or INFORMATION banner
     *
     * @param bannerInfo - a {@see com.xebialabs.deployit.core.api.dto.BannerInfo} object containing the banner kind and content
     */
    @PUT
    @Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    void updateBannerInfo(BannerInfo bannerInfo);

}
