package com.xebialabs.deployit.core.api;

import ai.digital.deploy.sql.model.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.QueryParam;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Stream;

public interface InternalReportProxyDefaults extends InternalReportProxy {

    static MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    default Stream<ReportLine> getTaskReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @BeanParam Paging paging,
            @QueryParam("order") List<Ordering> order,
            @QueryParam("filterType") String filterType,
            @QueryParam("users") List<String> users,
            @QueryParam("states") List<String> states,
            @QueryParam("taskId") String taskId,
            @QueryParam("worker") String workerName,
            List<ConfigurationItemId> configurationItemIds) {
        return getTaskReport(begin, end, paging, order, filterType, users, states, taskId, workerName, configurationItemIds);
    }

    default String downloadTaskReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @QueryParam("filterType") String filterType,
            @QueryParam("users") List<String> users,
            @QueryParam("states") List<String> states,
            @QueryParam("taskId") String taskId,
            @QueryParam("worker") String workerName,
            List<ConfigurationItemId> configurationItemIds) {
        return downloadTaskReport(begin, end, filterType, users, states, taskId, workerName, configurationItemIds);
    }

}
