package com.xebialabs.deployit.core.api;
import ai.digital.deploy.sql.model.UserTokensView;
import ai.digital.deploy.sql.model.CreatePersonalAccessTokenForm;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import org.springframework.web.bind.annotation.RequestBody;

@Path("/tokens")
@Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON })
public interface XldUserTokenService {

    @GET
    @Path("/users")
    UserTokensView getUserTokens(
            @BeanParam Paging paging,
            @QueryParam("order") Ordering order,
            @QueryParam("tokenNote") String tokenNote);

    @GET
    @Path("/users/{username}")
    UserTokensView getTokensForUsername(@PathParam("username") String username, @BeanParam Paging paging, @QueryParam("order") Ordering order,@QueryParam("tokenNote") String tokenNote);

    @GET
    @Path("/users/token/{token}")
    String getUsernameForToken(@PathParam("token") String token);

    @POST
    @Path("/users")
    UserTokensView generateUserToken(@RequestBody CreatePersonalAccessTokenForm userTokenForm);

    @DELETE
    @Path("/users/{username}/{ciId}")
    void deleteUserTokenByUsernameAndCiId(@PathParam("username") String username, @PathParam("ciId") Integer ciId);

    @DELETE
    @Path("/users/{ciId}")
    void deleteUserTokenByCiId(@PathParam("ciId") Integer ciId);

}
