package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.PropertyValue;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.resteasy.Date;
import org.jboss.resteasy.annotations.ClientResponseType;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

@Path("/deployit/history")
@Consumes({MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_XML})
public interface HistoryProxy {

	@GET
	@Path("query")
	@ClientResponseType(entityType = RepositoryObjects.class)
	Response query(@QueryParam("typeName") String typeName, @QueryParam("archetype") boolean archetype, @QueryParam("page") long page,
	               @QueryParam("resultsPerPage") long resultPerPage, @QueryParam("property") List<PropertyValue> values, @QueryParam("at") Date at);

}
