package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.ImportablePackages;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import org.jboss.resteasy.annotations.ClientResponseType;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/deployit/importablePackages")
@Consumes({MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_XML})
public interface ImportablePackageProxy {

	@GET
	@ClientResponseType(entityType = ImportablePackages.class)
	Response list();

	@POST
	@Path("import/{file:.*?}")
	@ClientResponseType(entityType = RepositoryObject.class)
	Response importPackage(@PathParam("file") String file);

    @POST
    @Path("import-url")
    @ClientResponseType(entityType = RepositoryObject.class)
    Response importPackageFromUrl(String url);


	@POST
	@Path("import")
	@Consumes(MediaType.MULTIPART_FORM_DATA)
	@ClientResponseType(entityType = RepositoryObject.class)
	Response importUploadedPackage(@MultipartForm FileUpload form);

}
