package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import org.jboss.resteasy.annotations.ClientResponseType;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path("/deployit/repository")
@Consumes({ MediaType.APPLICATION_XML })
@Produces({ MediaType.APPLICATION_XML })
public interface RepositoryProxy {

	@POST
	@Path("{id:.*?}")
	@ClientResponseType(entityType = RepositoryObject.class)
	Response create(@PathParam("id") String id, RepositoryObject entity);

	@POST
	@Path("{id:.*?}")
	@Consumes({ MediaType.MULTIPART_FORM_DATA })
	@ClientResponseType(entityType = RepositoryObject.class)
	Response create(@PathParam("id") String id, @MultipartForm ArtifactAndData artifactAndData);

    @POST
	@Path("create-multiple")
	@ClientResponseType(entityType = RepositoryObjects.class)
	Response createMultiple(RepositoryObjects repositoryObjects);

	@GET
	@Path("{id:.*?}")
	@ClientResponseType(entityType = RepositoryObject.class)
	Response read(@PathParam("id") String id);

	@PUT
	@Path("{id:.*?}")
	@ClientResponseType(entityType = RepositoryObject.class)
	Response update(@PathParam("id") String id, RepositoryObject entity);

	@PUT
	@Path("{id:.*?}")
	@Consumes({ MediaType.MULTIPART_FORM_DATA })
	@ClientResponseType(entityType = RepositoryObject.class)
	Response update(@PathParam("id") String id, @MultipartForm ArtifactAndData artifactAndData);

	@DELETE
	@Path("{id:.*?}")
	Response delete(@PathParam("id") String id);

}
