package com.xebialabs.deployit.core.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.jboss.resteasy.annotations.ClientResponseType;

import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfos;
import com.xebialabs.deployit.core.api.resteasy.Date;

/**
 */
@Path("/deployit/task")
@Consumes(MediaType.APPLICATION_XML)
@Produces(MediaType.APPLICATION_XML)
public interface TaskProxy {

	
	@GET
	@ClientResponseType(entityType = TaskInfos.class)
	Response getUnfinishedTasks();
	
	@GET
	@Path("{taskid}/steps")
	@ClientResponseType(entityType = Steps.class)
	Response getStepsForTask(@PathParam("taskid") String taskId);
	
    @POST
    @Path("{taskid}/start")
    Response start(@PathParam("taskid") String taskId);
	
    @DELETE
    @Path("{taskid:.*?}")
    Response cancel(@PathParam("taskid") String taskId);

    @POST
    @Path("{taskid}/stop")
    Response stop(@PathParam("taskid") String taskId);

    @POST
    @Path("{taskid}/abort")
    Response abort(@PathParam("taskid") String taskId);

    @GET
    @Path("{taskid}")
    @ClientResponseType(entityType = TaskInfo.class)
    Response getTaskInfo(@PathParam("taskid") String taskId);

    @POST
    @Path("{taskid}/toggle-skip")
    @ClientResponseType(entityType = Steps.class)
    Response toggleSkipSteps(@PathParam("taskid") String taskId, String stepIds);


    /**
     * Retrieves information about a step.
     *
     * @param taskId          the ID of the task
     * @param stepNr          the ordinal number of the step, starting from 1
     * @param ifModifiedSince the if-modified-since date in <a href="http://datatracker.ietf.org/doc/rfc1123/">RFC 1123</a> (<a href="http://datatracker.ietf.org/doc/rfc822/">RFC 822</a> with 4-digit years) date format.
     * @return if the step has not been modified since <tt>ifModifiedSince</tt>, a {@link Response} with a status code of 304 (Not Modified), otherwise a
     *         {@link Response} with a status code of 200 (OK) and an entity of type {@link StepInfo}.
     */
    @GET
    @Path("{taskid}/steps/{stepnr}")
    @ClientResponseType(entityType = StepInfo.class)
    Response getStepInfo(@PathParam("taskid") String taskId, @PathParam("stepnr") int stepNr, @HeaderParam("If-Modified-Since") Date ifModifiedSince);

}
