package com.xebialabs.deployit.core.api.dto;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;

import com.google.common.collect.Lists;


public class ConfigurationItemPropertyDescriptorDto extends AbstractDTO {

	private String name;

	private ConfigurationItemPropertyType type;

	private String[] enumValues;

	private String collectionMemberClassname;

	private String propertyClassname;

	private String label;
	
	private boolean required;

	private boolean editable;

	private boolean password;

	private boolean identifying;

	private boolean discoveryParam;

	private boolean discoveryRequired;
	
	private boolean asContainment;

	private String category;

	private String defaultValue;

    private String description;

	private List<ConfigurationItemPropertyDescriptorDto> listObjectPropertyDescriptors = Lists.newArrayList();


	public ConfigurationItemPropertyDescriptorDto() {
	}
	
	public void setName(final String name) {
		this.name = name;
	}

	public void setType(final ConfigurationItemPropertyType type) {
		this.type = type;
	}

	public void setEnumValues(final String[] enumValues) {
		this.enumValues = enumValues;
	}

	public void setCollectionMemberClassname(final String collectionMemberClassname) {
		this.collectionMemberClassname = collectionMemberClassname;
	}

	public void setPropertyClassname(final String propertyClassname) {
		this.propertyClassname = propertyClassname;
	}

	public void setRequired(final boolean required) {
		this.required = required;
	}

	public void setEditable(final boolean editable) {
		this.editable = editable;
	}

	public void setPassword(final boolean password) {
		this.password = password;
	}

	public void setIdentifying(final boolean identifying) {
		this.identifying = identifying;
	}

	public void setDiscoveryParam(final boolean discoveryParam) {
		this.discoveryParam = discoveryParam;
	}

	public void setDiscoveryRequired(final boolean discoveryRequired) {
		this.discoveryRequired = discoveryRequired;
	}
	
	public final void setAsContainment(boolean asContainment) {
		this.asContainment = asContainment;
	}

	public void setCategory(final String category) {
		this.category = category;
	}

	public void setDefaultValue(final String defaultValue) {
		this.defaultValue = defaultValue;
	}

	

	public void setLabel(String label) {
		this.label = label;
	}

	public void addPropertyDescriptor(final ConfigurationItemPropertyDescriptorDto configurationItemPropertyDescriptorDto) {
		listObjectPropertyDescriptors.add(configurationItemPropertyDescriptorDto);
	}
	
	@XmlElement
	public String getLabel() {
		return label;
	}

	@XmlElement
	public String getName() {
    	return name;
    }

	@XmlElement
	public ConfigurationItemPropertyType getType() {
    	return type;
    }

	@XmlElement
	public String[] getEnumValues() {
    	return enumValues;
    }

	@XmlElement
	public String getCollectionMemberClassname() {
    	return collectionMemberClassname;
    }

	@XmlElement
	public String getPropertyClassname() {
    	return propertyClassname;
    }

	@XmlElement
	public boolean isRequired() {
    	return required;
    }

	@XmlElement
	public boolean isEditable() {
    	return editable;
    }

	@XmlElement
	public boolean isPassword() {
    	return password;
    }
	
	@XmlElement
	public boolean isIdentifying() {
    	return identifying;
    }

	@XmlElement
	public boolean isDiscoveryParam() {
    	return discoveryParam;
    }

	@XmlElement
	public boolean isDiscoveryRequired() {
    	return discoveryRequired;
    }

	@XmlElement
	public String getCategory() {
    	return category;
    }

	@XmlElement
	public String getDefaultValue() {
    	return defaultValue;
    }
	
	@XmlElement
	public List<ConfigurationItemPropertyDescriptorDto> getPropertyDescriptors() {
    	return listObjectPropertyDescriptors;
    }

    @XmlElement
    public String getDescription() {
        return description;
    }

    @XmlElement
    public final boolean isAsContainment() {
    	return asContainment;
    }
    
    public void setDescription(final String description) {
        this.description = description;
    }

}
