package com.xebialabs.deployit.core.api.dto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@XmlRootElement
public class Deployment {

	private ConfigurationItem deployedApplication;

	private List<ConfigurationItem> deployeds = newArrayList();
	private boolean upgrade;

	@XmlElement(name = "deployed-application")
	public ConfigurationItem getDeployedApplication() {
		return deployedApplication;
	}

	@XmlElement(name = "deployeds")
	public List<ConfigurationItem> getDeployeds() {
		return deployeds;
	}

	@XmlElement(name = "upgrade")
	public boolean isUpgrade() {
		return upgrade;
	}

	public void setUpgrade(boolean upgrade) {
		this.upgrade = upgrade;
	}

	public void setDeployedApplication(ConfigurationItem deployedApplication) {
		this.deployedApplication = deployedApplication;
	}

	public void setDeployeds(List<ConfigurationItem> deployeds) {
		this.deployeds = deployeds;
	}

	public void add(ConfigurationItem object) {
		this.deployeds.add(object);
	}

    public void addAll(List<ConfigurationItem> deployeds) {
        this.deployeds.addAll(deployeds);
    }

	public String getVersion() {
		return (String) deployedApplication.getValues().get("version");
	}

	public String getEnvironment() {
		return (String) deployedApplication.getValues().get("environment");
	}
}
