package com.xebialabs.deployit.core.api.jaxb;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MapAdapter extends XmlAdapter<MapElement[], Map<String, Object>> {

	@SuppressWarnings("unchecked")
	public MapElement[] marshal(Map<String, Object> map) throws Exception {
		List<MapElement> elements = Lists.newArrayList();
		if (map != null) {
			for (Map.Entry<String, Object> each : map.entrySet()) {
				Object eachValue = each.getValue();
				Object mapValue;
				if (eachValue instanceof Map) {
					mapValue = new MapMapElement((Map<String, String>) eachValue);
				} else if (eachValue instanceof Collection) {
					Collection<?> c = (Collection<?>) eachValue;
					if (c.isEmpty()) {
						mapValue = null;
					} else {
						Object object = c.iterator().next();
						if (object instanceof String) {
							mapValue = new CollectionOfStringsMapElement((Collection<String>) c);
						} else {
							String message = each.getKey() + " is a collection but the contents " + object + " is not String";
							logger.error(message);
							throw new IllegalArgumentException(message);
						}
					}
				} else if (eachValue instanceof String) {
					mapValue = eachValue;
				} else if (eachValue instanceof RepositoryObject) {
					mapValue = eachValue;
				} else {
					String message = "Property " + each.getKey() + " is not a Collection, String or RepositoryObject, but a " + eachValue.getClass();
					logger.error(message);
					throw new IllegalArgumentException(message);
				}
				if (mapValue != null) {
					elements.add(new MapElement(each.getKey(), mapValue));
				}
			}
		}
		return elements.toArray(new MapElement[elements.size()]);
	}

	public Map<String, Object> unmarshal(MapElement[] values) throws Exception {
		Map<String, Object> map = Maps.newHashMap();
		for (MapElement each : values) {
			Object eachValue = each.getValue();
			Object mapValue;
			if (eachValue instanceof CollectionOfStringsMapElement) {
				mapValue = ((CollectionOfStringsMapElement) eachValue).getStrings();
			} else if (eachValue instanceof MapMapElement) {
				mapValue = ((MapMapElement) eachValue).getMap();
			} else if (eachValue instanceof String) {
				mapValue = (String) eachValue;
			} else if (eachValue instanceof RepositoryObject) {
				mapValue = (RepositoryObject) eachValue;
			} else {
				String message = "Property " + each.getKey() + " is not of a recognized type but it is: " + eachValue;
				logger.error(message);
				throw new IllegalArgumentException(message);
			}
			map.put(each.getKey(), mapValue);
		}
		return map;
	}

	private static final Logger logger = LoggerFactory.getLogger(MapAdapter.class);
}
