package com.xebialabs.deployit.core.api.jaxb;

import java.util.Set;
import java.util.Map;
import java.util.Map.Entry;
import javax.xml.bind.annotation.adapters.XmlAdapter;

import static com.google.common.collect.Sets.newTreeSet;
import static com.google.common.collect.Maps.newTreeMap;

public class PrincipalPermissionsMapAdapter extends XmlAdapter<PrincipalPermissionList, Map<String, Set<String>>> {
	@Override
	public PrincipalPermissionList marshal(final Map<String, Set<String>> principalPermissions) throws Exception {
		PrincipalPermissionList principalPermissionList = new PrincipalPermissionList();
		if (principalPermissions != null){
			for (Entry<String, Set<String>> permission : principalPermissions.entrySet()) {
				principalPermissionList.addPermissionEntry(new PrincipalPermissionEntry(permission.getKey(), permission.getValue()));
			}
		}
		return principalPermissionList;
	}

	@Override
	public Map<String, Set<String>> unmarshal(final PrincipalPermissionList principalPermissionList) throws Exception {
		Map<String, Set<String>> principalPermissionsMap = newTreeMap();
		for (PrincipalPermissionEntry principalPermissionEntry : principalPermissionList) {
			principalPermissionsMap.put(principalPermissionEntry.getPermission(), newTreeSet(principalPermissionEntry.getTargets()));
		}		
		return principalPermissionsMap;
	}
}
