package com.xebialabs.deployit.core.api.resteasy.http.tunnel;

import java.util.List;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;

import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 */
public class ResponseFactory {

	public static Response.ResponseBuilder getInstance() {
		final HttpRequest request = ResteasyProviderFactory.getContextData(HttpRequest.class);
		if (request != null) {
			final List<String> values = request.getHttpHeaders().getRequestHeader(HeaderName.WANT_TUNNEL_HEADER.getHeader());
			if (values != null && !values.isEmpty()) {
				logger.debug("Returning TunneledResponseBuilder for {}", request);
				return new TunneledResponseBuilder();
			}
		}

		logger.debug("Returning regular ResponseBuilder for {}", request);
		return RuntimeDelegate.getInstance().createResponseBuilder();
	}

	public static Response.ResponseBuilder status(final Response.Status status) {
		return getInstance().status(status);
	}

	public static Response.ResponseBuilder status(final int status) {
		return getInstance().status(status);
	}

	public static Response.ResponseBuilder serverError() {
		return getInstance().status(Response.Status.INTERNAL_SERVER_ERROR);
	}

	public static Response.ResponseBuilder ok(final Object entity) {
		return getInstance().status(Response.Status.OK).entity(entity);
	}

	public static Response.ResponseBuilder noContent() {
		return getInstance().status(Response.Status.NO_CONTENT);
	}

	public static Response.ResponseBuilder notModified() {
		return getInstance().status(Response.Status.NOT_MODIFIED);
	}

	public static Response.ResponseBuilder created(final Object entity) {
		return getInstance().status(Response.Status.CREATED).entity(entity);
	}

    public static Response.ResponseBuilder badRequest(final Object entity) {
        return getInstance().status(Response.Status.BAD_REQUEST).entity(entity);
    }

	private static Logger logger = LoggerFactory.getLogger(ResponseFactory.class);

    public static Response.ResponseBuilder accepted() {
        return getInstance().status(Response.Status.ACCEPTED);
    }
}
