package com.xebialabs.deployit.core.api.dto;

import static com.google.common.collect.Lists.newArrayList;

import java.util.Collection;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "access-control-list")
public class AccessControlList extends AbstractDTO {

	private Collection<AccessControlEntry> entries = newArrayList();

	public AccessControlList() {
		//
	}

	public AccessControlList(Collection<AccessControlEntry> entries) {
		this.entries = entries;
	}

	@XmlElement(name = "entries")
	public Collection<AccessControlEntry> getEntries() {
		return entries;
	}

	public void setEntries(Collection<AccessControlEntry> entries) {
		this.entries = entries;
	}

    public void addEntry(AccessControlEntry entry) {
        entries.add(entry);
    }
}
