package com.xebialabs.deployit.core.api.dto;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "repository-objects")
public class ConfigurationItemDtos extends AbstractDTO {

	private List<ConfigurationItemDto> objects = newArrayList();

	@XmlElement(name = "repository-object")
	public List<ConfigurationItemDto> getObjects() {
		return objects;
	}

	public void setObjects(final List<ConfigurationItemDto> objects) {
		this.objects = objects;
	}

	public void clear() {
		this.objects.clear();
	}

	public void add(ConfigurationItemDto object) {
		this.objects.add(object);
	}

    public void addAll(List<ConfigurationItemDto> configurationItemEntities) {
        this.objects.addAll(configurationItemEntities);
    }
}
